import { Component, OnDestroy, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { Subscription } from 'rxjs';
import { NgxSpinnerService } from 'ngx-spinner';
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';
import { environment } from 'src/environments/environment';
import { HttpClient } from '@angular/common/http';

import {
  GroupingState,
  IFetchSelectedAction,
  IFilterView,
  IGroupingView,
  ISearchView,
  ISortView,
  IUpdateStatusForSelectedAction,
  PaginatorState,
  SortState
} from '../../../_metronic/shared/crud-table';
import { ivrsService } from '../_services';
import { useractivityService } from '../_services/useractivity.service';

@Component({
  selector: 'app-user-activity',
  templateUrl: './user-activity-credentials.component.html',
  styleUrls: ['./user-activity-credentials.component.scss']
})
export class UserActivityCredentialsComponent
  implements
    OnInit,
    IFetchSelectedAction,
    IUpdateStatusForSelectedAction,
    ISortView,
    IFilterView,
    IGroupingView,
    ISearchView,
    IFilterView
{
  paginator: PaginatorState;
  sorting: SortState;
  grouping: GroupingState;
  isLoading: boolean;
  filterGroup: FormGroup;
  searchGroup: FormGroup;
  private subscriptions: Subscription[] = []; // Read more: => https://brianflove.com/2016/12/11/anguar-2-unsubscribe-observables/
  API_URL = `${environment.apiUrl}/user-activity`;
  getnotno:any;
  dataAvailable: boolean = false;
  summarydata:any;


  constructor(private fb: FormBuilder, private http: HttpClient, private modalService: NgbModal,private spinner: NgxSpinnerService, public useractivityService: useractivityService) {}

  // angular lifecircle hooks
  ngOnInit(): void {
    this.spinner.show();
    this.filterForm();
    this.searchForm();
    this.useractivityService.fetch();
   
    const sb = this.useractivityService.isLoading$.subscribe(res => {
      if (!res) {
        this.spinner.hide(); // Hide the spinner when loading is complete
      }
    });
    this.subscriptions.push(sb);
    this.grouping = this.useractivityService.grouping;
    this.paginator = this.useractivityService.paginator;
    this.sorting = this.useractivityService.sorting;

    this.http.get(this.API_URL).subscribe(data => {
      this.summarydata = data;

      if(this.summarydata.length > 0){
        this.dataAvailable = true;
      }else{
        this.dataAvailable = false;
      }
       
     }) ; 

  }

  ngOnDestroy() {
    this.subscriptions.forEach(sb => sb.unsubscribe());
  }

  // filtration
  filterForm() {
    this.filterGroup = this.fb.group({
      status: [''],
      condition: [''],
      searchTerm: ['']
    });
    this.subscriptions.push(this.filterGroup.controls.status.valueChanges.subscribe(() => this.filter()));
    this.subscriptions.push(this.filterGroup.controls.condition.valueChanges.subscribe(() => this.filter()));
  }

  filter() {
    const filter = {};
    const status = this.filterGroup.get('status').value;
    if (status) {
      filter['status'] = status;
    }

    const condition = this.filterGroup.get('condition').value;
    if (condition) {
      filter['condition'] = condition;
    }
    this.useractivityService.patchState({ filter });
  }

  // search
  searchForm() {
    this.searchGroup = this.fb.group({
      searchTerm: ['']
    });
    const searchEvent = this.searchGroup.controls.searchTerm.valueChanges
      .pipe(
        /*
  The user can type quite quickly in the input box, and that could trigger a lot of server requests. With this operator,
  we are limiting the amount of server requests emitted to a maximum of one every 150ms
  */
        debounceTime(150),
        distinctUntilChanged()
      )
      .subscribe(val => this.search(val));
    this.subscriptions.push(searchEvent);
  }

  search(searchTerm: string) {
    this.useractivityService.patchState({ searchTerm });
  }

  // sorting
  sort(column: string) {
    const sorting = this.sorting;
    const isActiveColumn = sorting.column === column;
    if (!isActiveColumn) {
      sorting.column = column;
      sorting.direction = 'asc';
    } else {
      sorting.direction = sorting.direction === 'asc' ? 'desc' : 'asc';
    }
    this.useractivityService.patchState({ sorting });
  }

  // pagination
  paginate(paginator: PaginatorState) {
    this.useractivityService.patchState({ paginator });
  }
  // actions
 

  deleteSelected() {}

  updateStatusForSelected() {}

  fetchSelected() {}

  download(){
    console.log("all card",this.summarydata.length);
    let jsondata =JSON.parse(JSON.stringify(this.summarydata));
    console.log("export data",jsondata);
     this.downloadFile(jsondata, 'User Activity');
   }
 
   downloadFile(data, filename='data') {
 
     let csvData = this.ConvertToCSV(data, ['client_name','email','ip_address','description','last_login']);
     
     let blob = new Blob(['\ufeff' + csvData], { type: 'text/csv;charset=utf-8;' });
     let dwldLink = document.createElement("a");
     let url = URL.createObjectURL(blob);
     let isSafariBrowser = navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1;
     if (isSafariBrowser) {  //if Safari open in new window to save file with random filename.
         dwldLink.setAttribute("target", "_blank");
     }
     dwldLink.setAttribute("href", url);
     dwldLink.setAttribute("download", filename + ".csv");
     dwldLink.style.visibility = "hidden";
     document.body.appendChild(dwldLink);
     dwldLink.click();
     document.body.removeChild(dwldLink);
 }
 
 ConvertToCSV(objArray, headerList) {
      let array = typeof objArray != 'object' ? JSON.parse(objArray) : objArray;
      let str = '';
      let row = 'S.No,';
 
      for (let index in headerList) {
          row += headerList[index] + ',';
      }
      row = row.slice(0, -1);
      str += row + '\r\n';
      for (let i = 0; i < array.length; i++) {
          let line = (i+1)+'';
          for (let index in headerList) {
             let head = headerList[index];
 
              line += ',' + array[i][head];
          }
          str += line + '\r\n';
      }
      return str;
  }

 
}
