import { Component, Input, OnDestroy, OnInit } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { of, Subscription } from 'rxjs';
import { catchError, delay, finalize, tap } from 'rxjs/operators';
 import { FileDisputeService } from '../../../_services';
 
@Component({
  selector: 'app-delete-filedispute-modal',
  templateUrl: './delete-filedispute-modal.component.html',
  styleUrls: ['./delete-filedispute-modal.component.scss']
})
export class DeleteFiledisputeModalComponent implements OnInit,OnDestroy {
  @Input() id: number;
  isLoading = false;
  subscriptions: Subscription[] = [];

 
  constructor(private filedisputeService: FileDisputeService, public modal: NgbActiveModal) { }

  ngOnInit(): void {
  }

  
  deleteFileDispute() {
   // alert(this.id);
    this.isLoading = true;

    const sb = this.filedisputeService.delete(this.id).pipe(
       delay(1000), // Remove it from your code (just for showing loading)
     
      tap(() => this.modal.close()),
      catchError((errorMessage) => {
        this.modal.dismiss(errorMessage);
        return of(undefined);
      }),
      finalize(() => {
        this.isLoading = false;
      })
    ).subscribe();
    this.subscriptions.push(sb);
  }

  ngOnDestroy(): void {
    this.subscriptions.forEach(sb => sb.unsubscribe());
  }

}
