import { HttpClient } from '@angular/common/http';
import { Inject, Injectable, OnDestroy } from '@angular/core';
import { forkJoin, Observable } from 'rxjs';
import { exhaustMap, map } from 'rxjs/operators';
import { baseFilter } from 'src/app/_fake/fake-helpers/http-extenstions';
import {
  GroupingState,
  ITableState,
  PaginatorState,
  SortState,
  TableResponseModel,
  TableService
} from 'src/app/_metronic/shared/crud-table';
import { environment } from 'src/environments/environment';
import { UserActivityPage } from '../_models/useractivity.model';

const DEFAULT_STATE: ITableState = {
  filter: {},
  paginator: new PaginatorState(),
  sorting: new SortState(),
  searchTerm: '',
  grouping: new GroupingState(),
  entityId: undefined
};

@Injectable({
  providedIn: 'root'
})
export class useractivityService extends TableService<UserActivityPage> implements OnDestroy {
  API_URL = `${environment.apiUrl}/user-activity`;

  constructor(@Inject(HttpClient) http) {
    super(http);
  }

  // READ
  getLotNo(): Observable<any> {
    return this.http.get(`${environment.apiUrl}/lotno`);
  }

  find(tableState: ITableState): Observable<TableResponseModel<UserActivityPage>> {
    return this.http.get<UserActivityPage[]>(this.API_URL).pipe(
      map((response: UserActivityPage[]) => {
        const filteredResult = baseFilter(response, tableState);
        const result: TableResponseModel<UserActivityPage> = {
          items: filteredResult.items,
          total: filteredResult.total
        };
        return result;
      })
    );
  }
  deleteItems(ids: number[] = []): Observable<any> {
    const tasks$ = [];
    ids.forEach(id => {
      tasks$.push(this.delete(id));
    });
    return forkJoin(tasks$);
  }

  updateStatusForItems(ids: number[], status: number): Observable<any> {
    return this.http.get<UserActivityPage[]>(this.API_URL).pipe(
      map((UserActivityPage: UserActivityPage[]) => {
        return UserActivityPage
          .filter(c => ids.indexOf(c.id) > -1)
          .map(c => {
            //c.status = status;
            return c;
          });
      }),
      exhaustMap((UserActivityPage: UserActivityPage[]) => {
        const tasks$ = [];
        UserActivityPage.forEach(UserActivityPage => {
          tasks$.push(this.update(UserActivityPage));
        });
        return forkJoin(tasks$);
      })
    );
  }

  ngOnDestroy() {
    this.subscriptions.forEach(sb => sb.unsubscribe());
  }
}
