import { HttpClient } from '@angular/common/http';
import { Component, OnInit , ChangeDetectorRef } from '@angular/core';
import { FormGroup, FormBuilder } from '@angular/forms';
import { NgbDate, NgbCalendar, NgbDateParserFormatter, NgbDatepickerConfig } from '@ng-bootstrap/ng-bootstrap';
import { Subscription } from 'rxjs';
import { environment } from 'src/environments/environment'; 


@Component({
  selector: 'app-accountsummary',
  templateUrl: './accountsummary.component.html',
  styleUrls: ['./accountsummary.component.scss']
})
export class AccountsummaryComponent implements OnInit {

  API_URL = `${environment.apiUrl}/accountsummary`;
  hoveredDate: NgbDate | null = null;
  fromdate: string;
  todate: string;
  isLoading: boolean;
  filterGroup: FormGroup;
  searchGroup: FormGroup;
  lot_no: '';
  
  summarydata:any;
  getnotno:any;

  constructor(
    private fb: FormBuilder, 
    private http: HttpClient,
    private calendar: NgbCalendar,
    public formatter: NgbDateParserFormatter,
    private config: NgbDatepickerConfig,
    private cdRef: ChangeDetectorRef
  ) { }

  ngOnInit() {
    this.getnotno= localStorage.getItem("currentlotno");

    this.http.get(this.API_URL + '?lotno='+this.getnotno).subscribe(data => {
      this.summarydata = data;
     }) ; 
  }


  formatDate(field: string, date: string): void {
    // Reformat the date to "MM/DD/YYYY"
    const [year, month, day] = date.split('-');

    if (field === 'fromdate') {
      this.fromdate = `${month}/${day}/${year}`;
    } else if (field === 'todate') {
      this.todate = `${month}/${day}/${year}`;
    }
  }

  handleButtonClick(): void {
    // Code to be executed when the button is clicked
    this.getnotno = localStorage.getItem("currentlotno");

    
    this.http.get(this.API_URL + '?lotno=' + this.getnotno + '&fromdate=' + this.fromdate + "&todate=" + this.todate).subscribe(data => {
      this.summarydata = data;
      // Code that relies on this.summarydata goes here
      // This code will run after the response arrives
      this.cdRef.detectChanges();
    });
    

  }



}
