import React from 'react';
import { Link } from 'react-router-dom';
import Button from '../../../components/ui/Button';
import Icon from '../../../components/AppIcon';

const WelcomeStep = ({ userData, onStartTour }) => {
  const benefits = [
    {
      icon: 'Calendar',
      title: 'Smart Scheduling',
      description: 'Plan and schedule content across all your platforms'
    },
    {
      icon: 'BarChart3',
      title: 'Analytics Dashboard',
      description: 'Track performance and optimize your content strategy'
    },
    {
      icon: 'Users',
      title: 'Team Collaboration',
      description: 'Work together seamlessly with your team members'
    },
    {
      icon: 'Zap',
      title: 'AI-Powered Tools',
      description: 'Get content suggestions and optimization tips'
    }
  ];

  return (
    <div className="text-center space-y-8">
      <div className="space-y-4">
        <div className="w-20 h-20 mx-auto bg-gradient-to-br from-primary to-secondary rounded-full flex items-center justify-center">
          <Icon name="CheckCircle" size={40} color="white" />
        </div>
        
        <div>
          <h2 className="text-2xl font-bold text-text-primary mb-2">
            Welcome to Social Composer Pro, {userData?.firstName}!
          </h2>
          <p className="text-lg text-text-secondary">
            Your account has been created successfully. You're ready to transform your social media management.
          </p>
        </div>
      </div>
      <div className="bg-muted rounded-lg p-6">
        <h3 className="text-lg font-semibold text-text-primary mb-4">
          What's next?
        </h3>
        
        <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
          {benefits?.map((benefit, index) => (
            <div key={index} className="flex items-start space-x-3 text-left">
              <div className="flex-shrink-0 w-8 h-8 bg-primary/10 rounded-lg flex items-center justify-center">
                <Icon name={benefit?.icon} size={16} color="var(--color-primary)" />
              </div>
              <div>
                <h4 className="font-medium text-text-primary text-sm">
                  {benefit?.title}
                </h4>
                <p className="text-xs text-text-secondary">
                  {benefit?.description}
                </p>
              </div>
            </div>
          ))}
        </div>
      </div>
      <div className="space-y-4">
        <Button
          variant="default"
          size="lg"
          fullWidth
          onClick={onStartTour}
          iconName="Play"
          iconPosition="left"
        >
          Start Product Tour
        </Button>
        
        <Button
          variant="outline"
          size="lg"
          fullWidth
          asChild
        >
          <Link to="/dashboard">
            Go to Dashboard
          </Link>
        </Button>
      </div>
      <div className="text-center pt-4">
        <p className="text-sm text-text-secondary">
          Need help getting started? Check out our{' '}
          <Link to="/resources" className="text-primary hover:underline">
            getting started guide
          </Link>{' '}
          or{' '}
          <Link to="/support" className="text-primary hover:underline">
            contact support
          </Link>
        </p>
      </div>
    </div>
  );
};

export default WelcomeStep;