import React, { useState } from 'react';

import Icon from '../../../components/AppIcon';

const UserTypeSelection = ({ onSelect, selectedType }) => {
  const userTypes = [
    {
      id: 'creator',
      title: 'Content Creator',
      description: 'Individual creators managing personal brands and multiple social platforms',
      features: [
        'Multi-platform publishing',
        'Content calendar',
        'Analytics dashboard',
        'Template library'
      ],
      icon: 'User',
      color: 'border-primary bg-primary/5',
      popular: true
    },
    {
      id: 'agency',
      title: 'Marketing Agency',
      description: 'Teams managing multiple clients with collaborative workflows',
      features: [
        'Team collaboration',
        'Client management',
        'Advanced analytics',
        'White-label reports'
      ],
      icon: 'Users',
      color: 'border-secondary bg-secondary/5',
      popular: false
    },
    {
      id: 'business',
      title: 'Small Business',
      description: 'Business owners seeking simple automation without complexity',
      features: [
        'Easy scheduling',
        'Basic analytics',
        'Template suggestions',
        'Customer engagement'
      ],
      icon: 'Building',
      color: 'border-accent bg-accent/5',
      popular: false
    }
  ];

  return (
    <div className="space-y-6">
      <div className="text-center">
        <h3 className="text-xl font-semibold text-text-primary mb-2">
          What best describes you?
        </h3>
        <p className="text-text-secondary">
          Help us personalize your experience
        </p>
      </div>
      <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
        {userTypes?.map((type) => (
          <div
            key={type?.id}
            className={`relative p-6 rounded-lg border-2 cursor-pointer transition-all duration-300 hover:shadow-lg ${
              selectedType === type?.id
                ? type?.color
                : 'border-border bg-background hover:border-primary/30'
            }`}
            onClick={() => onSelect(type?.id)}
          >
            {type?.popular && (
              <div className="absolute -top-3 left-1/2 transform -translate-x-1/2">
                <span className="bg-primary text-white text-xs font-medium px-3 py-1 rounded-full">
                  Most Popular
                </span>
              </div>
            )}

            <div className="text-center space-y-4">
              <div className={`w-12 h-12 mx-auto rounded-lg flex items-center justify-center ${
                selectedType === type?.id ? 'bg-primary text-white' : 'bg-muted text-text-secondary'
              }`}>
                <Icon name={type?.icon} size={24} color="currentColor" />
              </div>

              <div>
                <h4 className="text-lg font-semibold text-text-primary mb-2">
                  {type?.title}
                </h4>
                <p className="text-sm text-text-secondary mb-4">
                  {type?.description}
                </p>
              </div>

              <ul className="space-y-2 text-left">
                {type?.features?.map((feature, index) => (
                  <li key={index} className="flex items-center space-x-2 text-sm">
                    <Icon name="Check" size={16} color="var(--color-success)" />
                    <span className="text-text-secondary">{feature}</span>
                  </li>
                ))}
              </ul>
            </div>

            <div className={`absolute inset-0 rounded-lg border-2 pointer-events-none transition-all duration-300 ${
              selectedType === type?.id ? 'border-primary shadow-lg' : 'border-transparent'
            }`} />
          </div>
        ))}
      </div>
    </div>
  );
};

export default UserTypeSelection;