import React from 'react';
import Button from '../../../components/ui/Button';
import Icon from '../../../components/AppIcon';

const SocialSignUp = ({ onSocialSignUp, loading }) => {
  const socialProviders = [
    {
      id: 'google',
      name: 'Google',
      icon: 'Chrome',
      color: 'bg-red-500 hover:bg-red-600',
      textColor: 'text-white'
    },
    {
      id: 'facebook',
      name: 'Facebook',
      icon: 'Facebook',
      color: 'bg-blue-600 hover:bg-blue-700',
      textColor: 'text-white'
    },
    {
      id: 'twitter',
      name: 'Twitter',
      icon: 'Twitter',
      color: 'bg-sky-500 hover:bg-sky-600',
      textColor: 'text-white'
    }
  ];

  return (
    <div className="space-y-4">
      <div className="text-center">
        <p className="text-sm text-text-secondary mb-4">
          Sign up with your social account
        </p>
      </div>
      <div className="grid grid-cols-1 gap-3">
        {socialProviders?.map((provider) => (
          <Button
            key={provider?.id}
            variant="outline"
            size="default"
            fullWidth
            onClick={() => onSocialSignUp(provider?.id)}
            disabled={loading}
            className="justify-center"
          >
            <div className="flex items-center justify-center space-x-3">
              <Icon 
                name={provider?.icon} 
                size={20} 
                color="currentColor"
              />
              <span>Continue with {provider?.name}</span>
            </div>
          </Button>
        ))}
      </div>
      <div className="relative my-6">
        <div className="absolute inset-0 flex items-center">
          <div className="w-full border-t border-border"></div>
        </div>
        <div className="relative flex justify-center text-sm">
          <span className="px-4 bg-background text-text-secondary">
            Or sign up with email
          </span>
        </div>
      </div>
    </div>
  );
};

export default SocialSignUp;