import React from 'react';
import Icon from '../../../components/AppIcon';

const OnboardingProgress = ({ currentStep, totalSteps }) => {
  const steps = [
    {
      id: 1,
      title: 'Account Details',
      description: 'Basic information'
    },
    {
      id: 2,
      title: 'User Type',
      description: 'Tell us about yourself'
    },
    {
      id: 3,
      title: 'Platform Setup',
      description: 'Connect your accounts'
    },
    {
      id: 4,
      title: 'Welcome',
      description: 'You\'re all set!'
    }
  ];

  return (
    <div className="w-full max-w-4xl mx-auto mb-8">
      <div className="flex items-center justify-between">
        {steps?.map((step, index) => (
          <React.Fragment key={step?.id}>
            <div className="flex flex-col items-center space-y-2">
              <div 
                className={`w-10 h-10 rounded-full flex items-center justify-center border-2 transition-all duration-300 ${
                  currentStep > step?.id
                    ? 'bg-success border-success text-white'
                    : currentStep === step?.id
                    ? 'bg-primary border-primary text-white' :'bg-background border-border text-text-secondary'
                }`}
              >
                {currentStep > step?.id ? (
                  <Icon name="Check" size={16} color="white" />
                ) : (
                  <span className="text-sm font-medium">{step?.id}</span>
                )}
              </div>
              <div className="text-center">
                <p className={`text-sm font-medium ${
                  currentStep >= step?.id ? 'text-text-primary' : 'text-text-secondary'
                }`}>
                  {step?.title}
                </p>
                <p className="text-xs text-text-secondary hidden sm:block">
                  {step?.description}
                </p>
              </div>
            </div>
            
            {index < steps?.length - 1 && (
              <div className="flex-1 mx-4">
                <div 
                  className={`h-0.5 transition-all duration-300 ${
                    currentStep > step?.id ? 'bg-success' : 'bg-border'
                  }`}
                />
              </div>
            )}
          </React.Fragment>
        ))}
      </div>
    </div>
  );
};

export default OnboardingProgress;