import React, { useState } from 'react';
import Icon from '../../../components/AppIcon';
import Input from '../../../components/ui/Input';
import Button from '../../../components/ui/Button';

const NewsletterSignup = () => {
  const [email, setEmail] = useState('');
  const [isSubscribed, setIsSubscribed] = useState(false);
  const [isLoading, setIsLoading] = useState(false);

  const handleSubmit = async (e) => {
    e?.preventDefault();
    if (!email) return;

    setIsLoading(true);
    
    // Simulate API call
    setTimeout(() => {
      setIsSubscribed(true);
      setIsLoading(false);
      setEmail('');
    }, 1500);
  };

  if (isSubscribed) {
    return (
      <div className="bg-gradient-to-br from-success/10 to-success/5 rounded-2xl p-8 text-center">
        <div className="w-16 h-16 bg-success/20 rounded-full flex items-center justify-center mx-auto mb-4">
          <Icon name="CheckCircle" size={32} className="text-success" />
        </div>
        <h3 className="text-xl font-bold text-text-primary mb-2">
          Welcome to the Community!
        </h3>
        <p className="text-text-secondary mb-6">
          You'll receive our weekly digest with the latest insights, guides, and resources.
        </p>
        <Button 
          variant="outline" 
          onClick={() => setIsSubscribed(false)}
          className="text-success border-success hover:bg-success hover:text-white"
        >
          Subscribe Another Email
        </Button>
      </div>
    );
  }

  return (
    <div className="bg-gradient-to-br from-primary/10 to-secondary/10 rounded-2xl p-8">
      <div className="text-center mb-6">
        <div className="w-16 h-16 bg-primary/20 rounded-full flex items-center justify-center mx-auto mb-4">
          <Icon name="Mail" size={32} className="text-primary" />
        </div>
        <h3 className="text-xl font-bold text-text-primary mb-2">
          Stay Ahead of the Curve
        </h3>
        <p className="text-text-secondary">
          Get weekly insights, exclusive templates, and early access to new resources delivered to your inbox.
        </p>
      </div>
      <form onSubmit={handleSubmit} className="space-y-4">
        <Input
          type="email"
          placeholder="Enter your email address"
          value={email}
          onChange={(e) => setEmail(e?.target?.value)}
          required
          className="text-center"
        />
        
        <Button
          type="submit"
          variant="default"
          size="lg"
          fullWidth
          loading={isLoading}
          disabled={!email}
          iconName="ArrowRight"
          iconPosition="right"
        >
          {isLoading ? 'Subscribing...' : 'Subscribe to Weekly Digest'}
        </Button>
      </form>
      <div className="flex items-center justify-center gap-6 mt-6 pt-6 border-t border-border/50">
        <div className="flex items-center gap-2">
          <Icon name="Users" size={16} className="text-primary" />
          <span className="text-sm text-text-secondary">12,000+ subscribers</span>
        </div>
        <div className="flex items-center gap-2">
          <Icon name="Shield" size={16} className="text-primary" />
          <span className="text-sm text-text-secondary">No spam, ever</span>
        </div>
      </div>
    </div>
  );
};

export default NewsletterSignup;