import React from 'react';
import Image from '../../../components/AppImage';
import Icon from '../../../components/AppIcon';
import Button from '../../../components/ui/Button';

const FeaturedSection = ({ featuredResources, onViewResource }) => {
  const mainFeatured = featuredResources?.[0];
  const secondaryFeatured = featuredResources?.slice(1, 3);

  return (
    <section className="mb-12">
      <div className="flex items-center justify-between mb-8">
        <div>
          <h2 className="text-2xl font-bold text-text-primary mb-2">Featured Resources</h2>
          <p className="text-text-secondary">
            Hand-picked content to accelerate your social media success
          </p>
        </div>
        <Button variant="outline" iconName="ArrowRight" iconPosition="right">
          View All Featured
        </Button>
      </div>
      <div className="grid lg:grid-cols-2 gap-8">
        {/* Main Featured */}
        <div className="bg-gradient-to-br from-primary/5 to-secondary/5 rounded-2xl overflow-hidden group cursor-pointer"
             onClick={() => onViewResource(mainFeatured)}>
          <div className="relative">
            <Image
              src={mainFeatured?.image}
              alt={mainFeatured?.title}
              className="w-full h-64 object-cover group-hover:scale-105 smooth-transition"
            />
            <div className="absolute top-6 left-6">
              <span className="bg-primary text-white px-3 py-1 rounded-full text-sm font-medium">
                Featured
              </span>
            </div>
            {mainFeatured?.duration && (
              <div className="absolute bottom-6 right-6 bg-black/70 text-white px-3 py-1 rounded text-sm">
                {mainFeatured?.duration}
              </div>
            )}
          </div>
          
          <div className="p-8">
            <div className="flex items-center gap-2 mb-4">
              <Icon name="Star" size={16} className="text-accent fill-current" />
              <span className="text-sm text-text-secondary">{mainFeatured?.category}</span>
              <span className="text-sm text-text-secondary">•</span>
              <span className="text-sm text-text-secondary">{mainFeatured?.readTime}</span>
            </div>
            
            <h3 className="text-xl font-bold text-text-primary mb-3 group-hover:text-primary smooth-transition">
              {mainFeatured?.title}
            </h3>
            
            <p className="text-text-secondary mb-6">
              {mainFeatured?.description}
            </p>
            
            <div className="flex items-center justify-between">
              <div className="flex items-center gap-3">
                <Image
                  src={mainFeatured?.author?.avatar}
                  alt={mainFeatured?.author?.name}
                  className="w-8 h-8 rounded-full"
                />
                <div>
                  <p className="text-sm font-medium text-text-primary">{mainFeatured?.author?.name}</p>
                  <p className="text-xs text-text-secondary">{mainFeatured?.author?.role}</p>
                </div>
              </div>
              
              <Button variant="default" size="sm" iconName="ArrowRight" iconPosition="right">
                Read More
              </Button>
            </div>
          </div>
        </div>

        {/* Secondary Featured */}
        <div className="space-y-6">
          {secondaryFeatured?.map((resource) => (
            <div
              key={resource?.id}
              className="bg-white rounded-xl creative-confidence-shadow hover:hero-dramatic-shadow smooth-transition p-6 group cursor-pointer"
              onClick={() => onViewResource(resource)}
            >
              <div className="flex gap-4">
                <div className="relative flex-shrink-0">
                  <Image
                    src={resource?.image}
                    alt={resource?.title}
                    className="w-24 h-24 object-cover rounded-lg group-hover:scale-105 smooth-transition"
                  />
                  {resource?.type === 'video' && (
                    <div className="absolute inset-0 flex items-center justify-center">
                      <div className="bg-black/70 rounded-full p-2">
                        <Icon name="Play" size={16} className="text-white" />
                      </div>
                    </div>
                  )}
                </div>
                
                <div className="flex-1 min-w-0">
                  <div className="flex items-center gap-2 mb-2">
                    <span className="text-xs text-primary font-medium">{resource?.category}</span>
                    <span className="text-xs text-text-secondary">•</span>
                    <span className="text-xs text-text-secondary">{resource?.readTime}</span>
                  </div>
                  
                  <h4 className="font-semibold text-text-primary mb-2 line-clamp-2 group-hover:text-primary smooth-transition">
                    {resource?.title}
                  </h4>
                  
                  <p className="text-sm text-text-secondary line-clamp-2 mb-3">
                    {resource?.description}
                  </p>
                  
                  <div className="flex items-center justify-between">
                    <div className="flex items-center gap-2">
                      <Image
                        src={resource?.author?.avatar}
                        alt={resource?.author?.name}
                        className="w-5 h-5 rounded-full"
                      />
                      <span className="text-xs text-text-secondary">{resource?.author?.name}</span>
                    </div>
                    
                    <Icon name="ArrowRight" size={16} className="text-text-secondary group-hover:text-primary smooth-transition" />
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default FeaturedSection;