import React from 'react';
import Icon from '../../../components/AppIcon';

const CategoryTabs = ({ categories, activeCategory, onCategoryChange }) => {
  const getCategoryIcon = (category) => {
    switch (category) {
      case 'all': return 'Grid3X3';
      case 'blog': return 'FileText';
      case 'guide': return 'BookOpen';
      case 'template': return 'Layout';
      case 'webinar': return 'Video';
      case 'calculator': return 'Calculator';
      case 'video': return 'Play';
      default: return 'File';
    }
  };

  return (
    <div className="mb-8">
      <div className="flex flex-wrap gap-2">
        {categories?.map((category) => (
          <button
            key={category?.value}
            onClick={() => onCategoryChange(category?.value)}
            className={`flex items-center gap-2 px-4 py-2 rounded-lg font-medium micro-transition ${
              activeCategory === category?.value
                ? 'bg-primary text-white shadow-lg'
                : 'bg-white text-text-secondary hover:text-text-primary hover:bg-muted border border-border'
            }`}
          >
            <Icon 
              name={getCategoryIcon(category?.value)} 
              size={16} 
              className={activeCategory === category?.value ? 'text-white' : 'text-current'} 
            />
            <span className="text-sm">{category?.label}</span>
            <span className={`text-xs px-2 py-1 rounded-full ${
              activeCategory === category?.value
                ? 'bg-white/20 text-white' :'bg-muted text-text-secondary'
            }`}>
              {category?.count}
            </span>
          </button>
        ))}
      </div>
    </div>
  );
};

export default CategoryTabs;