import React, { useState, useEffect } from 'react';
import { Helmet } from 'react-helmet';
import Header from '../../components/ui/Header';
import FeatureHero from './components/FeatureHero';
import FeatureNavigation from './components/FeatureNavigation';
import ComposerFeature from './components/ComposerFeature';
import CalendarFeature from './components/CalendarFeature';
import AnalyticsFeature from './components/AnalyticsFeature';
import CollaborationFeature from './components/CollaborationFeature';
import ComparisonTable from './components/ComparisonTable';
import TestimonialsSection from './components/TestimonialsSection';

const ProductFeatures = () => {
  const [activeFeature, setActiveFeature] = useState('composer');

  // Scroll to feature section when navigation changes
  useEffect(() => {
    const element = document.getElementById(activeFeature);
    if (element) {
      element?.scrollIntoView({ behavior: 'smooth', block: 'start' });
    }
  }, [activeFeature]);

  return (
    <>
      <Helmet>
        <title>Product Features - Social Composer Pro | Advanced Social Media Management</title>
        <meta 
          name="description" 
          content="Explore Social Composer Pro's powerful features: AI-powered composer, visual calendar, advanced analytics, and team collaboration tools. Transform your social media workflow today." 
        />
        <meta 
          name="keywords" 
          content="social media management, content creation, AI composer, social media calendar, analytics, team collaboration, multi-platform publishing" 
        />
        <meta property="og:title" content="Product Features - Social Composer Pro" />
        <meta 
          property="og:description" 
          content="Discover the comprehensive suite of tools that make Social Composer Pro the #1 choice for content creators and marketing teams." 
        />
        <meta property="og:type" content="website" />
        <link rel="canonical" href="/product-features" />
      </Helmet>
      <div className="min-h-screen bg-background">
        <Header />
        
        {/* Hero Section */}
        <FeatureHero />
        
        {/* Feature Navigation */}
        <FeatureNavigation 
          activeFeature={activeFeature} 
          onFeatureChange={setActiveFeature} 
        />
        
        {/* Feature Sections */}
        <div id="composer">
          <ComposerFeature />
        </div>
        
        <div id="calendar">
          <CalendarFeature />
        </div>
        
        <div id="analytics">
          <AnalyticsFeature />
        </div>
        
        <div id="collaboration">
          <CollaborationFeature />
        </div>
        
        {/* Comparison Table */}
        <ComparisonTable />
        
        {/* Customer Testimonials */}
        <TestimonialsSection />
        
        {/* Footer CTA */}
        <section className="bg-gradient-to-r from-primary to-secondary py-16">
          <div className="max-w-4xl mx-auto text-center px-4 sm:px-6 lg:px-8">
            <h2 className="text-3xl md:text-4xl font-bold text-white mb-6">
              Ready to Transform Your Content Strategy?
            </h2>
            <p className="text-xl text-white/90 mb-8 leading-relaxed">
              Join thousands of creators and marketers who've revolutionized their social media workflow with Social Composer Pro. Start your free trial today and experience the difference.
            </p>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
              <button className="bg-white text-primary px-8 py-4 rounded-xl font-semibold text-lg micro-interaction hover:scale-105 creative-confidence-shadow">
                Start Free Trial
              </button>
              <button className="border-2 border-white text-white px-8 py-4 rounded-xl font-semibold text-lg micro-interaction hover:bg-white hover:text-primary">
                Schedule Demo
              </button>
            </div>
            
            <div className="flex items-center justify-center mt-8 text-white/80">
              <svg className="w-5 h-5 mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path fillRule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clipRule="evenodd" />
              </svg>
              <span>No credit card required • 14-day free trial • Cancel anytime</span>
            </div>
          </div>
        </section>
        
        {/* Footer */}
        <footer className="bg-text-primary text-white py-12">
          <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div className="grid md:grid-cols-4 gap-8">
              <div>
                <div className="flex items-center space-x-2 mb-4">
                  <div className="w-8 h-8 bg-gradient-to-br from-primary to-secondary rounded-lg flex items-center justify-center">
                    <svg className="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                      <path d="M11 3a1 1 0 100 2h2.586l-6.293 6.293a1 1 0 101.414 1.414L15 6.414V9a1 1 0 102 0V4a1 1 0 00-1-1h-5z" />
                      <path d="M5 5a2 2 0 00-2 2v8a2 2 0 002 2h8a2 2 0 002-2v-3a1 1 0 10-2 0v3H5V7h3a1 1 0 000-2H5z" />
                    </svg>
                  </div>
                  <span className="text-xl font-bold">Social Composer Pro</span>
                </div>
                <p className="text-gray-400 text-sm">
                  Empowering creators with intelligent social media management tools.
                </p>
              </div>
              
              <div>
                <h4 className="font-semibold mb-4">Product</h4>
                <ul className="space-y-2 text-sm text-gray-400">
                  <li><a href="/product-features" className="hover:text-white micro-transition">Features</a></li>
                  <li><a href="/pricing" className="hover:text-white micro-transition">Pricing</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">Integrations</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">API</a></li>
                </ul>
              </div>
              
              <div>
                <h4 className="font-semibold mb-4">Resources</h4>
                <ul className="space-y-2 text-sm text-gray-400">
                  <li><a href="/resources" className="hover:text-white micro-transition">Blog</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">Help Center</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">Community</a></li>
                  <li><a href="/customer-stories" className="hover:text-white micro-transition">Case Studies</a></li>
                </ul>
              </div>
              
              <div>
                <h4 className="font-semibold mb-4">Company</h4>
                <ul className="space-y-2 text-sm text-gray-400">
                  <li><a href="#" className="hover:text-white micro-transition">About</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">Careers</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">Contact</a></li>
                  <li><a href="#" className="hover:text-white micro-transition">Privacy</a></li>
                </ul>
              </div>
            </div>
            
            <div className="border-t border-gray-800 mt-8 pt-8 text-center text-sm text-gray-400">
              <p>&copy; {new Date()?.getFullYear()} Social Composer Pro. All rights reserved.</p>
            </div>
          </div>
        </footer>
      </div>
    </>
  );
};

export default ProductFeatures;