import React, { useState } from 'react';
import Icon from '../../../components/AppIcon';

const FeatureNavigation = ({ activeFeature, onFeatureChange }) => {
  const features = [
    {
      id: 'composer',
      name: 'Smart Composer',
      icon: 'Edit3',
      description: 'AI-powered content creation'
    },
    {
      id: 'calendar',
      name: 'Visual Calendar',
      icon: 'Calendar',
      description: 'Strategic content planning'
    },
    {
      id: 'analytics',
      name: 'Advanced Analytics',
      icon: 'BarChart3',
      description: 'Performance insights'
    },
    {
      id: 'collaboration',
      name: 'Team Collaboration',
      icon: 'Users',
      description: 'Seamless teamwork'
    }
  ];

  return (
    <section className="bg-white py-16 sticky top-16 z-40 border-b border-border">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col lg:flex-row items-center justify-between mb-8">
          <div>
            <h2 className="text-3xl font-bold text-text-primary mb-2">
              Explore Our Features
            </h2>
            <p className="text-text-secondary">
              Click on any feature to see it in action
            </p>
          </div>
          
          <div className="flex items-center space-x-2 mt-4 lg:mt-0">
            <Icon name="Info" size={16} color="var(--color-text-secondary)" />
            <span className="text-sm text-text-secondary">
              Interactive demos available
            </span>
          </div>
        </div>
        
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
          {features?.map((feature) => (
            <button
              key={feature?.id}
              onClick={() => onFeatureChange(feature?.id)}
              className={`p-6 rounded-xl text-left micro-interaction hover:scale-105 ${
                activeFeature === feature?.id
                  ? 'bg-gradient-to-br from-primary to-secondary text-white creative-confidence-shadow'
                  : 'bg-muted hover:bg-gray-100 text-text-primary'
              }`}
            >
              <div className="flex items-center mb-3">
                <Icon 
                  name={feature?.icon} 
                  size={24} 
                  color={activeFeature === feature?.id ? 'white' : 'var(--color-primary)'} 
                />
                <h3 className="ml-3 font-semibold">{feature?.name}</h3>
              </div>
              <p className={`text-sm ${
                activeFeature === feature?.id ? 'text-white/80' : 'text-text-secondary'
              }`}>
                {feature?.description}
              </p>
            </button>
          ))}
        </div>
      </div>
    </section>
  );
};

export default FeatureNavigation;