import React from 'react';
import Icon from '../../../components/AppIcon';
import Button from '../../../components/ui/Button';

const FeatureHero = () => {
  return (
    <section className="bg-gradient-to-br from-indigo-50 via-white to-violet-50 pt-24 pb-16">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center max-w-4xl mx-auto">
          <div className="flex items-center justify-center mb-6">
            <div className="bg-gradient-to-r from-primary to-secondary p-3 rounded-2xl">
              <Icon name="Layers" size={32} color="white" strokeWidth={2} />
            </div>
          </div>
          
          <h1 className="text-4xl md:text-6xl font-bold text-text-primary mb-6 leading-tight">
            Powerful Features for
            <span className="bg-gradient-to-r from-primary to-secondary bg-clip-text text-transparent"> Content Creators</span>
          </h1>
          
          <p className="text-xl text-text-secondary mb-8 leading-relaxed max-w-3xl mx-auto">
            Transform your social media workflow with our comprehensive suite of tools designed for modern content creators. From intelligent composition to advanced analytics, every feature is crafted to amplify your creative potential.
          </p>
          
          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
            <Button 
              variant="default" 
              size="lg"
              iconName="Play"
              iconPosition="left"
              className="px-8"
            >
              Watch Demo
            </Button>
            <Button 
              variant="outline" 
              size="lg"
              iconName="ArrowRight"
              iconPosition="right"
              className="px-8"
            >
              Start Free Trial
            </Button>
          </div>
          
          <div className="mt-12 grid grid-cols-2 md:grid-cols-4 gap-8 text-center">
            <div>
              <div className="text-3xl font-bold text-primary mb-2">50M+</div>
              <div className="text-sm text-text-secondary">Posts Published</div>
            </div>
            <div>
              <div className="text-3xl font-bold text-primary mb-2">10K+</div>
              <div className="text-sm text-text-secondary">Active Creators</div>
            </div>
            <div>
              <div className="text-3xl font-bold text-primary mb-2">95%</div>
              <div className="text-sm text-text-secondary">Time Saved</div>
            </div>
            <div>
              <div className="text-3xl font-bold text-primary mb-2">24/7</div>
              <div className="text-sm text-text-secondary">Support Available</div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default FeatureHero;