import React, { useState } from 'react';
import Icon from '../../../components/AppIcon';
import Image from '../../../components/AppImage';
import Button from '../../../components/ui/Button';

const ComposerFeature = () => {
  const [activeTab, setActiveTab] = useState('editor');
  const [isTyping, setIsTyping] = useState(false);

  const tabs = [
    { id: 'editor', name: 'Smart Editor', icon: 'Edit3' },
    { id: 'templates', name: 'Templates', icon: 'Layout' },
    { id: 'ai', name: 'AI Assistant', icon: 'Sparkles' }
  ];

  const platforms = [
    { name: 'Instagram', icon: 'Instagram', color: '#E4405F', connected: true },
    { name: 'Twitter', icon: 'Twitter', color: '#1DA1F2', connected: true },
    { name: 'LinkedIn', icon: 'Linkedin', color: '#0077B5', connected: true },
    { name: 'Facebook', icon: 'Facebook', color: '#1877F2', connected: false }
  ];

  const handleTypingDemo = () => {
    setIsTyping(true);
    setTimeout(() => setIsTyping(false), 3000);
  };

  return (
    <section className="bg-white py-20">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Content */}
          <div>
            <div className="flex items-center mb-6">
              <div className="bg-primary/10 p-3 rounded-xl mr-4">
                <Icon name="Edit3" size={24} color="var(--color-primary)" />
              </div>
              <span className="text-primary font-semibold">Smart Composer</span>
            </div>
            
            <h2 className="text-4xl font-bold text-text-primary mb-6">
              Create Content That Converts Across All Platforms
            </h2>
            
            <p className="text-xl text-text-secondary mb-8 leading-relaxed">
              Our intelligent composer adapts your content for each platform automatically. Write once, publish everywhere with platform-specific optimizations that maximize engagement.
            </p>
            
            <div className="space-y-6 mb-8">
              <div className="flex items-start">
                <div className="bg-success/10 p-2 rounded-lg mr-4 mt-1">
                  <Icon name="Check" size={16} color="var(--color-success)" />
                </div>
                <div>
                  <h4 className="font-semibold text-text-primary mb-1">
                    AI-Powered Content Optimization
                  </h4>
                  <p className="text-text-secondary">
                    Automatically adjusts tone, hashtags, and format for each platform
                  </p>
                </div>
              </div>
              
              <div className="flex items-start">
                <div className="bg-success/10 p-2 rounded-lg mr-4 mt-1">
                  <Icon name="Check" size={16} color="var(--color-success)" />
                </div>
                <div>
                  <h4 className="font-semibold text-text-primary mb-1">
                    Rich Media Integration
                  </h4>
                  <p className="text-text-secondary">
                    Drag-and-drop images, videos, and GIFs with automatic resizing
                  </p>
                </div>
              </div>
              
              <div className="flex items-start">
                <div className="bg-success/10 p-2 rounded-lg mr-4 mt-1">
                  <Icon name="Check" size={16} color="var(--color-success)" />
                </div>
                <div>
                  <h4 className="font-semibold text-text-primary mb-1">
                    Real-time Collaboration
                  </h4>
                  <p className="text-text-secondary">
                    Work with your team in real-time with comments and suggestions
                  </p>
                </div>
              </div>
            </div>
            
            <div className="flex flex-col sm:flex-row gap-4">
              <Button 
                variant="default" 
                size="lg"
                iconName="Play"
                iconPosition="left"
                onClick={handleTypingDemo}
              >
                Try Interactive Demo
              </Button>
              <Button 
                variant="outline" 
                size="lg"
                iconName="ExternalLink"
                iconPosition="right"
              >
                View Templates
              </Button>
            </div>
          </div>
          
          {/* Interactive Demo */}
          <div className="relative">
            <div className="bg-gradient-to-br from-gray-50 to-white rounded-2xl creative-confidence-shadow p-6">
              {/* Tab Navigation */}
              <div className="flex space-x-1 mb-6 bg-muted rounded-lg p-1">
                {tabs?.map((tab) => (
                  <button
                    key={tab?.id}
                    onClick={() => setActiveTab(tab?.id)}
                    className={`flex items-center px-4 py-2 rounded-md text-sm font-medium micro-transition ${
                      activeTab === tab?.id
                        ? 'bg-white text-primary creative-confidence-shadow'
                        : 'text-text-secondary hover:text-text-primary'
                    }`}
                  >
                    <Icon name={tab?.icon} size={16} className="mr-2" />
                    {tab?.name}
                  </button>
                ))}
              </div>
              
              {/* Platform Selector */}
              <div className="flex flex-wrap gap-2 mb-6">
                {platforms?.map((platform) => (
                  <div
                    key={platform?.name}
                    className={`flex items-center px-3 py-2 rounded-lg text-sm ${
                      platform?.connected
                        ? 'bg-success/10 text-success border border-success/20' :'bg-gray-100 text-text-secondary border border-gray-200'
                    }`}
                  >
                    <Icon name={platform?.icon} size={16} className="mr-2" />
                    {platform?.name}
                    {platform?.connected && (
                      <Icon name="Check" size={14} className="ml-2" />
                    )}
                  </div>
                ))}
              </div>
              
              {/* Content Editor */}
              <div className="bg-white rounded-lg border border-border p-4 mb-4">
                <div className="flex items-center justify-between mb-3">
                  <span className="text-sm font-medium text-text-secondary">
                    Compose your post
                  </span>
                  <div className="flex items-center space-x-2">
                    <Icon name="Image" size={16} color="var(--color-text-secondary)" />
                    <Icon name="Video" size={16} color="var(--color-text-secondary)" />
                    <Icon name="Smile" size={16} color="var(--color-text-secondary)" />
                  </div>
                </div>
                
                <div className="min-h-[120px] p-3 bg-gray-50 rounded-lg border border-gray-200 relative">
                  {isTyping ? (
                    <div className="space-y-2">
                      <div className="animate-pulse">
                        <div className="h-4 bg-gray-300 rounded w-3/4 mb-2"></div>
                        <div className="h-4 bg-gray-300 rounded w-1/2 mb-2"></div>
                        <div className="h-4 bg-gray-300 rounded w-2/3"></div>
                      </div>
                      <div className="flex items-center mt-4">
                        <div className="animate-spin mr-2">
                          <Icon name="Loader2" size={16} color="var(--color-primary)" />
                        </div>
                        <span className="text-sm text-primary">AI is optimizing your content...</span>
                      </div>
                    </div>
                  ) : (
                    <div className="text-text-secondary">
                      <p className="mb-2">
                        🚀 Excited to share our latest product update! Our new AI-powered composer makes content creation 10x faster.
                      </p>
                      <p className="text-sm text-primary">#SocialMedia #ContentCreation #AI</p>
                    </div>
                  )}
                </div>
              </div>
              
              {/* Preview Panels */}
              <div className="grid grid-cols-2 gap-3">
                <div className="bg-gradient-to-br from-pink-50 to-purple-50 p-3 rounded-lg border">
                  <div className="flex items-center mb-2">
                    <Icon name="Instagram" size={16} color="#E4405F" />
                    <span className="ml-2 text-xs font-medium">Instagram</span>
                  </div>
                  <div className="text-xs text-text-secondary">
                    Optimized with trending hashtags and visual focus
                  </div>
                </div>
                
                <div className="bg-gradient-to-br from-blue-50 to-cyan-50 p-3 rounded-lg border">
                  <div className="flex items-center mb-2">
                    <Icon name="Twitter" size={16} color="#1DA1F2" />
                    <span className="ml-2 text-xs font-medium">Twitter</span>
                  </div>
                  <div className="text-xs text-text-secondary">
                    Condensed for character limit with thread option
                  </div>
                </div>
              </div>
            </div>
            
            {/* Floating Success Metrics */}
            <div className="absolute -top-4 -right-4 bg-white rounded-xl creative-confidence-shadow p-4 border border-success/20">
              <div className="flex items-center">
                <div className="bg-success/10 p-2 rounded-lg mr-3">
                  <Icon name="TrendingUp" size={16} color="var(--color-success)" />
                </div>
                <div>
                  <div className="text-sm font-semibold text-text-primary">+245%</div>
                  <div className="text-xs text-text-secondary">Engagement</div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default ComposerFeature;