import React from 'react';
import Icon from '../../../components/AppIcon';
import Image from '../../../components/AppImage';

const TestimonialCard = ({ testimonial }) => {
  const renderStars = (rating) => {
    return Array.from({ length: 5 }, (_, index) => (
      <Icon
        key={index}
        name="Star"
        size={16}
        className={index < rating ? "text-yellow-400 fill-current" : "text-gray-300"}
      />
    ));
  };

  return (
    <div className="bg-white rounded-xl border border-gray-200 p-6 hover:shadow-lg transition-shadow duration-300">
      {/* Rating */}
      <div className="flex items-center mb-4">
        <div className="flex space-x-1 mr-2">
          {renderStars(testimonial?.rating)}
        </div>
        <span className="text-sm font-medium text-gray-700">
          {testimonial?.rating}.0
        </span>
      </div>
      {/* Quote */}
      <blockquote className="text-gray-700 mb-6 leading-relaxed">
        "{testimonial?.quote}"
      </blockquote>
      {/* Metrics */}
      {testimonial?.metrics && (
        <div className="grid grid-cols-2 gap-4 mb-6 p-4 bg-gray-50 rounded-lg">
          {testimonial?.metrics?.map((metric, index) => (
            <div key={index} className="text-center">
              <div className="text-2xl font-bold text-primary mb-1">
                {metric?.value}
              </div>
              <div className="text-xs text-gray-600">
                {metric?.label}
              </div>
            </div>
          ))}
        </div>
      )}
      {/* Author */}
      <div className="flex items-center">
        <div className="w-12 h-12 rounded-full overflow-hidden mr-4">
          <Image
            src={testimonial?.author?.avatar}
            alt={testimonial?.author?.name}
            className="w-full h-full object-cover"
          />
        </div>
        <div>
          <div className="font-semibold text-gray-900">
            {testimonial?.author?.name}
          </div>
          <div className="text-sm text-gray-600">
            {testimonial?.author?.title}
          </div>
          <div className="text-sm text-gray-500">
            {testimonial?.author?.company}
          </div>
        </div>
      </div>
      {/* Plan Badge */}
      {testimonial?.plan && (
        <div className="mt-4 pt-4 border-t border-gray-200">
          <span className="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
            <Icon name="Crown" size={12} className="mr-1" />
            {testimonial?.plan} Plan
          </span>
        </div>
      )}
    </div>
  );
};

export default TestimonialCard;