import React from 'react';
import Button from '../../../components/ui/Button';
import Icon from '../../../components/AppIcon';

const PricingCard = ({ 
  plan, 
  isPopular = false, 
  billingCycle = 'monthly',
  onSelectPlan 
}) => {
  const getPrice = () => {
    return billingCycle === 'monthly' ? plan?.monthlyPrice : plan?.annualPrice;
  };

  const getSavings = () => {
    if (billingCycle === 'annual' && plan?.savings) {
      return plan?.savings;
    }
    return null;
  };

  return (
    <div className={`relative bg-white rounded-2xl border-2 transition-all duration-300 hover:shadow-lg ${
      isPopular 
        ? 'border-primary shadow-lg scale-105' 
        : 'border-gray-200 hover:border-gray-300'
    }`}>
      {isPopular && (
        <div className="absolute -top-4 left-1/2 transform -translate-x-1/2">
          <div className="bg-gradient-to-r from-primary to-secondary text-white px-6 py-2 rounded-full text-sm font-semibold">
            Most Popular
          </div>
        </div>
      )}
      <div className="p-8">
        {/* Plan Header */}
        <div className="text-center mb-8">
          <h3 className="text-2xl font-bold text-gray-900 mb-2">{plan?.name}</h3>
          <p className="text-gray-600 mb-6">{plan?.description}</p>
          
          <div className="mb-6">
            <div className="flex items-baseline justify-center">
              <span className="text-5xl font-bold text-gray-900">${getPrice()}</span>
              <span className="text-gray-600 ml-2">
                /{billingCycle === 'monthly' ? 'month' : 'year'}
              </span>
            </div>
            {getSavings() && (
              <div className="mt-2">
                <span className="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                  <Icon name="TrendingDown" size={16} className="mr-1" />
                  Save {getSavings()}%
                </span>
              </div>
            )}
          </div>

          <Button
            variant={isPopular ? "default" : "outline"}
            size="lg"
            fullWidth
            onClick={() => onSelectPlan(plan)}
            className="mb-6"
          >
            {plan?.ctaText}
          </Button>
        </div>

        {/* Features List */}
        <div className="space-y-4">
          <h4 className="font-semibold text-gray-900 mb-4">Everything in {plan?.name}:</h4>
          {plan?.features?.map((feature, index) => (
            <div key={index} className="flex items-start">
              <Icon 
                name="Check" 
                size={20} 
                className="text-green-500 mr-3 mt-0.5 flex-shrink-0" 
              />
              <span className="text-gray-700">{feature}</span>
            </div>
          ))}
        </div>

        {/* Usage Limits */}
        {plan?.limits && (
          <div className="mt-6 pt-6 border-t border-gray-200">
            <h4 className="font-semibold text-gray-900 mb-3">Usage Limits:</h4>
            <div className="space-y-2">
              {plan?.limits?.map((limit, index) => (
                <div key={index} className="flex justify-between text-sm">
                  <span className="text-gray-600">{limit?.feature}</span>
                  <span className="font-medium text-gray-900">{limit?.value}</span>
                </div>
              ))}
            </div>
          </div>
        )}
      </div>
    </div>
  );
};

export default PricingCard;