import React, { useState } from 'react';
import Icon from '../../../components/AppIcon';

const FAQ = () => {
  const [openFAQ, setOpenFAQ] = useState(null);

  const faqs = [
    {
      question: "Can I change my plan at any time?",
      answer: `Yes, you can upgrade or downgrade your plan at any time. When you upgrade, you'll be charged the prorated difference immediately. When you downgrade, the change will take effect at your next billing cycle, and you'll continue to have access to your current plan's features until then.`
    },
    {
      question: "What happens during the free trial?",
      answer: `Your 14-day free trial gives you full access to all Professional plan features with no restrictions. You can connect up to 8 social media accounts, schedule unlimited posts, and access all our premium templates. No credit card is required to start your trial.`
    },
    {
      question: "Do you offer refunds?",
      answer: `We offer a 30-day money-back guarantee for all paid plans. If you're not completely satisfied with Social Composer Pro, contact our support team within 30 days of your purchase for a full refund. Annual subscriptions are also covered by this guarantee.`
    },
    {
      question: "How does team collaboration work?",
      answer: `Team collaboration features vary by plan. Professional plans include up to 5 team members with basic approval workflows. Enterprise plans offer unlimited team members, advanced role-based permissions, client access portals, and detailed activity logs to track all team actions.`
    },
    {
      question: "Which social media platforms do you support?",
      answer: `We support all major social media platforms including Instagram, Facebook, Twitter, LinkedIn, Pinterest, TikTok, YouTube, and more. Starter plans connect to 3 platforms, Professional plans support 8 platforms, and Enterprise plans include all current and future platform integrations.`
    },
    {
      question: "Is there a setup fee or long-term contract?",
      answer: `No setup fees and no long-term contracts required. You can cancel your subscription at any time. Annual plans offer significant savings but can still be cancelled with a prorated refund during the first 30 days.`
    },
    {
      question: "How does the AI caption generation work?",
      answer: `Our AI analyzes your visual content, brand voice, and audience engagement patterns to generate compelling captions. Starter plans include 50 AI captions per month, Professional plans get 500, and Enterprise plans have unlimited AI caption generation.`
    },
    {
      question: "Can I use my own branding in reports?",
      answer: `White-label reporting is available with Enterprise plans. You can customize reports with your own logo, colors, and branding to present professional reports to clients. This feature includes custom dashboard creation and branded PDF exports.`
    }
  ];

  const toggleFAQ = (index) => {
    setOpenFAQ(openFAQ === index ? null : index);
  };

  return (
    <div className="bg-white rounded-2xl border border-gray-200 overflow-hidden">
      <div className="bg-gray-50 px-8 py-6 border-b border-gray-200">
        <h3 className="text-2xl font-bold text-gray-900 mb-2">Frequently Asked Questions</h3>
        <p className="text-gray-600">
          Everything you need to know about our pricing and plans
        </p>
      </div>
      <div className="divide-y divide-gray-200">
        {faqs?.map((faq, index) => (
          <div key={index}>
            <button
              onClick={() => toggleFAQ(index)}
              className="w-full px-8 py-6 flex items-center justify-between hover:bg-gray-50 transition-colors text-left"
            >
              <h4 className="font-semibold text-gray-900 pr-4">{faq?.question}</h4>
              <Icon 
                name={openFAQ === index ? "ChevronUp" : "ChevronDown"} 
                size={20} 
                className="text-gray-500 flex-shrink-0" 
              />
            </button>
            
            {openFAQ === index && (
              <div className="px-8 pb-6">
                <p className="text-gray-700 leading-relaxed">
                  {faq?.answer}
                </p>
              </div>
            )}
          </div>
        ))}
      </div>
      <div className="bg-gray-50 px-8 py-6 border-t border-gray-200">
        <div className="text-center">
          <h4 className="font-semibold text-gray-900 mb-2">Still have questions?</h4>
          <p className="text-gray-600 mb-4">
            Our support team is here to help you find the perfect plan
          </p>
          <div className="flex flex-col sm:flex-row gap-3 justify-center">
            <a
              href="mailto:support@socialcomposerpro.com"
              className="inline-flex items-center justify-center px-4 py-2 border border-gray-300 rounded-lg text-sm font-medium text-gray-700 hover:bg-gray-50 transition-colors"
            >
              <Icon name="Mail" size={16} className="mr-2" />
              Email Support
            </a>
            <a
              href="#"
              className="inline-flex items-center justify-center px-4 py-2 bg-primary text-white rounded-lg text-sm font-medium hover:bg-primary/90 transition-colors"
            >
              <Icon name="MessageCircle" size={16} className="mr-2" />
              Live Chat
            </a>
          </div>
        </div>
      </div>
    </div>
  );
};

export default FAQ;