import React from 'react';
import Icon from '../../../components/AppIcon';
import Image from '../../../components/AppImage';

const PlatformIntegrations = () => {
  const platforms = [
    {
      name: "Facebook",
      icon: "Facebook",
      description: "Pages, Groups & Stories",
      color: "text-blue-600",
      bgColor: "bg-blue-50",
      users: "2.9B users"
    },
    {
      name: "Instagram",
      icon: "Instagram", 
      description: "Feed, Stories & Reels",
      color: "text-pink-600",
      bgColor: "bg-pink-50",
      users: "2B users"
    },
    {
      name: "Twitter",
      icon: "Twitter",
      description: "Tweets & Threads",
      color: "text-blue-400",
      bgColor: "bg-blue-50",
      users: "450M users"
    },
    {
      name: "LinkedIn",
      icon: "Linkedin",
      description: "Posts & Articles",
      color: "text-blue-700",
      bgColor: "bg-blue-50",
      users: "900M users"
    },
    {
      name: "YouTube",
      icon: "Youtube",
      description: "Videos & Shorts",
      color: "text-red-600",
      bgColor: "bg-red-50",
      users: "2.7B users"
    },
    {
      name: "TikTok",
      icon: "Music",
      description: "Short Videos",
      color: "text-black",
      bgColor: "bg-gray-50",
      users: "1B users"
    },
    {
      name: "Pinterest",
      icon: "Image",
      description: "Pins & Boards",
      color: "text-red-500",
      bgColor: "bg-red-50",
      users: "450M users"
    },
    {
      name: "Snapchat",
      icon: "Camera",
      description: "Snaps & Stories",
      color: "text-yellow-500",
      bgColor: "bg-yellow-50",
      users: "750M users"
    }
  ];

  console.log("Looking for icon:", { icon: "Zap" });

const integrationFeatures = [
  {
    icon: "Zap",
    title: "One-Click Publishing",
    description: "Publish to all platforms simultaneously with platform-specific optimizations",
  },
  {
    icon: "Settings",
    title: "Auto-Formatting",
    description: "Content automatically adapts to each platform's requirements and best practices",
  },
  {
    icon: "BarChart3",
    title: "Unified Analytics",
    description: "Track performance across all platforms in one comprehensive dashboard",
  },
  {
    icon: "Clock",
    title: "Smart Scheduling",
    description: "AI-powered optimal timing for maximum engagement on each platform",
  },
];



  return (
    <section className="py-16 lg:py-24 bg-background">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {/* Header */}
        <div className="text-center mb-16">
          <div className="inline-flex items-center px-4 py-2 bg-secondary/10 rounded-full text-secondary text-sm font-medium mb-6">
            <Icon name="Link" size={16} className="mr-2" />
            Platform Integrations
          </div>
          
          <h2 className="text-3xl sm:text-4xl lg:text-5xl font-bold text-text-primary mb-6">
            Connect All Your
            <span className="block text-primary bg-clip-text bg-gradient-to-r from-primary to-secondary">
              Social Platforms
            </span>
          </h2>
          
          <p className="text-xl text-text-secondary max-w-3xl mx-auto">
            Seamlessly integrate with all major social media platforms. Create once, publish everywhere, and manage your entire social presence from one powerful dashboard.
          </p>
        </div>

        {/* Platform Grid */}
        <div className="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-4 gap-6 mb-16">
          {platforms?.map((platform, index) => (
            <div
              key={platform?.name}
              className="group relative bg-card rounded-xl p-6 creative-confidence-shadow hover:shadow-lg micro-interaction border border-border hover:border-primary/20"
            >
              <div className={`w-12 h-12 ${platform?.bgColor} rounded-lg flex items-center justify-center mb-4 group-hover:scale-110 micro-transition`}>
                <Icon 
                  name={platform?.icon} 
                  size={24} 
                  className={platform?.color}
                />
              </div>
              
              <h3 className="font-semibold text-text-primary mb-2">
                {platform?.name}
              </h3>
              
              <p className="text-sm text-text-secondary mb-3">
                {platform?.description}
              </p>
              
              <div className="text-xs text-text-secondary font-medium">
                {platform?.users}
              </div>

              {/* Connection Status */}
              <div className="absolute top-4 right-4 w-3 h-3 bg-success rounded-full opacity-0 group-hover:opacity-100 micro-transition"></div>
            </div>
          ))}
        </div>

        {/* Integration Features */}
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {integrationFeatures?.map((feature, index) => (
            <div key={index} className="text-center">
              <div className="w-16 h-16 bg-gradient-to-br from-primary to-secondary rounded-xl flex items-center justify-center mx-auto mb-4">
                <Icon 
                  name={feature?.icon} 
                  size={24} 
                  color="white"
                />
              </div>
              
              <h3 className="font-semibold text-text-primary mb-3">
                {feature?.title}
              </h3>
              
              <p className="text-text-secondary text-sm">
                {feature?.description}
              </p>
            </div>
          ))}
        </div>

        {/* CTA Section */}
        <div className="text-center mt-16">
          <div className="inline-flex items-center space-x-4 bg-gradient-to-r from-primary/10 to-secondary/10 rounded-2xl p-8">
            <div className="flex -space-x-2">
              {platforms?.slice(0, 5)?.map((platform, index) => (
                <div
                  key={index}
                  className={`w-10 h-10 ${platform?.bgColor} rounded-full flex items-center justify-center border-2 border-white`}
                >
                  <Icon 
                    name={platform?.icon} 
                    size={16} 
                    className={platform?.color}
                  />
                </div>
              ))}
              <div className="w-10 h-10 bg-muted rounded-full flex items-center justify-center border-2 border-white text-text-secondary text-xs font-bold">
                +3
              </div>
            </div>
            
            <div className="text-left">
              <h3 className="font-semibold text-text-primary mb-1">
                Ready to connect your platforms?
              </h3>
              <p className="text-sm text-text-secondary">
                Start your free trial and integrate all your accounts in minutes
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default PlatformIntegrations;