import React, { useState, useEffect } from 'react';
import { Link } from 'react-router-dom';
import Icon from '../../../components/AppIcon';
import Image from '../../../components/AppImage';
import Button from '../../../components/ui/Button';

const HeroSection = () => {
  const [currentDemo, setCurrentDemo] = useState(0);
  const [isAnimating, setIsAnimating] = useState(false);

  const demoScreens = [
    {
      id: 1,
      title: "Compose Once, Publish Everywhere",
      description: "Create your content in our intuitive composer and watch it adapt perfectly to every platform",
      image: "https://images.unsplash.com/photo-1611224923853-80b023f02d71?w=800&h=600&fit=crop&crop=entropy&auto=format",
      platforms: ["Facebook", "Twitter", "Instagram", "LinkedIn"]
    },
    {
      id: 2,
      title: "Smart Scheduling Made Simple",
      description: "AI-powered optimal posting times ensure maximum engagement across all your channels",
      image: "https://images.pexels.com/photos/590022/pexels-photo-590022.jpeg?w=800&h=600&fit=crop&crop=entropy&auto=format",
      platforms: ["Calendar", "Analytics", "Automation"]
    },
    {
      id: 3,
      title: "Real-Time Analytics Dashboard",
      description: "Track performance, measure ROI, and optimize your content strategy with actionable insights",
      image: "/assets/images/sample.png",
      platforms: ["Metrics", "Reports", "Growth"]
    }
  ];

  // useEffect(() => {
  //   const interval = setInterval(() => {
  //     setIsAnimating(true);
  //     setTimeout(() => {
  //       setCurrentDemo((prev) => (prev + 1) % demoScreens?.length);
  //       setIsAnimating(false);
  //     }, 300);
  //   }, 4000);

  //   return () => clearInterval(interval);
  // }, [demoScreens?.length]);

  // const handleDemoChange = (index) => {
  //   if (index !== currentDemo) {
  //     setIsAnimating(true);
  //     setTimeout(() => {
  //       setCurrentDemo(index);
  //       setIsAnimating(false);
  //     }, 300);
  //   }
  // };

  return (
    <section className="relative bg-gradient-to-br from-background via-muted/30 to-background pt-20 pb-16 overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-5">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/20 to-secondary/20"></div>
      </div>
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid lg:grid-cols-2 gap-12 lg:gap-16 items-center">
          {/* Left Content */}
          <div className="text-center lg:text-left">
            <div className="inline-flex items-center px-4 py-2 bg-primary/10 rounded-full text-primary text-sm font-medium mb-6">
              <Icon name="Sparkles" size={16} className="mr-2" />
              New: AI-Powered Content Optimization
            </div>

            <h1 className="text-4xl sm:text-5xl lg:text-6xl font-bold text-text-primary mb-6 leading-tight">
              Where Great Content
              <span className="block text-transparent bg-clip-text bg-gradient-to-r from-primary to-secondary">
                Meets Great Tools
              </span>
            </h1>

            <p className="text-xl text-text-secondary mb-8 max-w-2xl mx-auto lg:mx-0">
              Transform your social media chaos into streamlined creativity. Compose once, publish everywhere, and watch your engagement soar across all platforms.
            </p>

            <div className="flex flex-col sm:flex-row gap-4 justify-center lg:justify-start mb-8">
              <Button 
                variant="default" 
                size="lg"
                iconName="Play"
                iconPosition="left"
                asChild
              >
                <Link to="/sign-up">Start Free Trial</Link>
              </Button>
              
              <Button 
                variant="outline" 
                size="lg"
                iconName="Video"
                iconPosition="left"
              >
                Watch Demo
              </Button>
            </div>

            {/* Trust Indicators */}
            <div className="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-6 text-sm text-text-secondary">
              <div className="flex items-center">
                <Icon name="Check" size={16} className="text-success mr-2" />
                No credit card required
              </div>
              <div className="flex items-center">
                <Icon name="Users" size={16} className="text-primary mr-2" />
                Join 50,000+ creators
              </div>
              <div className="flex items-center">
                <Icon name="Star" size={16} className="text-warning mr-2" />
                4.9/5 rating
              </div>
            </div>
          </div>

          {/* Right Demo */}
          <div className="relative">
            <div className="relative bg-white rounded-2xl hero-dramatic-shadow p-6 lg:p-8">
              {/* Demo Navigation */}
              <div className="flex items-center justify-between mb-6">
                <div className="flex space-x-2">
                  {demoScreens?.map((_, index) => (
                    <button
                      key={index}
                      onClick={() => handleDemoChange(index)}
                      className={`w-3 h-3 rounded-full transition-all duration-300 ${
                        index === currentDemo 
                          ? 'bg-primary scale-110' :'bg-border hover:bg-primary/50'
                      }`}
                      aria-label={`Demo ${index + 1}`}
                    />
                  ))}
                </div>
                <div className="flex items-center space-x-1 text-xs text-text-secondary">
                  <Icon name="Wifi" size={12} />
                  <span>Live Demo</span>
                </div>
              </div>

              {/* Demo Content */}
              <div className={`transition-all duration-300 ${isAnimating ? 'opacity-0 scale-95' : 'opacity-100 scale-100'}`}>
                <div className="aspect-video bg-gradient-to-br from-muted to-background rounded-lg overflow-hidden mb-4 relative">
                  <Image
                    src={demoScreens?.[currentDemo]?.image}
                    alt={demoScreens?.[currentDemo]?.title}
                    className="w-full h-full object-cover"
                  />
                  <div className="absolute inset-0 bg-gradient-to-t from-black/50 to-transparent"></div>
                  <div className="absolute bottom-4 left-4 right-4">
                    <h3 className="text-white font-semibold text-lg mb-2">
                      {demoScreens?.[currentDemo]?.title}
                    </h3>
                    <p className="text-white/90 text-sm">
                      {demoScreens?.[currentDemo]?.description}
                    </p>
                  </div>
                </div>

                {/* Platform Tags */}
                <div className="flex flex-wrap gap-2">
                  {demoScreens?.[currentDemo]?.platforms?.map((platform, index) => (
                    <span
                      key={index}
                      className="inline-flex items-center px-3 py-1 bg-primary/10 text-primary text-xs font-medium rounded-full"
                    >
                      {platform}
                    </span>
                  ))}
                </div>
              </div>
            </div>

            {/* Floating Elements */}
            <div className="absolute -top-4 -right-4 w-20 h-20 bg-gradient-to-br from-secondary to-primary rounded-full opacity-20 animate-pulse"></div>
            <div className="absolute -bottom-6 -left-6 w-16 h-16 bg-gradient-to-br from-accent to-warning rounded-full opacity-20 animate-pulse delay-1000"></div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default HeroSection;