import React from 'react';
import { Link } from 'react-router-dom';
import Icon from '../../../components/AppIcon';
import Button from '../../../components/ui/Button';

const CTASection = () => {
  const features = [
    "14-day free trial",
    "No credit card required", 
    "Cancel anytime",
    "Full feature access"
  ];

  const stats = [
    { value: "30 min", label: "Average setup time" },
    { value: "5x", label: "Faster content creation" },
    { value: "24/7", label: "Customer support" }
  ];

  return (
    <section className="py-16 lg:py-24 bg-gradient-to-br from-primary via-primary to-secondary relative overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-10">
        <div className="absolute inset-0 bg-gradient-to-r from-white/20 to-transparent"></div>
        <div className="absolute top-0 left-1/4 w-96 h-96 bg-white/10 rounded-full blur-3xl"></div>
        <div className="absolute bottom-0 right-1/4 w-96 h-96 bg-white/10 rounded-full blur-3xl"></div>
      </div>
      <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center">
          {/* Header */}
          <div className="inline-flex items-center px-4 py-2 bg-white/20 rounded-full text-white text-sm font-medium mb-6">
            <Icon name="Rocket" size={16} className="mr-2" />
            Ready to Transform Your Social Media?
          </div>

          <h2 className="text-3xl sm:text-4xl lg:text-6xl font-bold text-white mb-6">
            Start Creating Amazing
            <span className="block">Content Today</span>
          </h2>

          <p className="text-xl text-white/90 mb-8 max-w-3xl mx-auto">
            Join thousands of creators, marketers, and businesses who've already transformed their social media workflow. Experience the power of Social Composer Pro risk-free.
          </p>

          {/* CTA Buttons */}
          <div className="flex flex-col sm:flex-row gap-4 justify-center mb-12">
            <Button 
              variant="secondary" 
              size="xl"
              iconName="Play"
              iconPosition="left"
              asChild
              className="bg-white text-primary hover:bg-white/90"
            >
              <Link to="/sign-up">Start Free Trial</Link>
            </Button>
            
            <Button 
              variant="outline" 
              size="xl"
              iconName="Calendar"
              iconPosition="left"
              className="border-white/30 text-white hover:bg-white/10"
            >
              Book a Demo
            </Button>
          </div>

          {/* Features List */}
          <div className="flex flex-wrap items-center justify-center gap-6 mb-12">
            {features?.map((feature, index) => (
              <div key={index} className="flex items-center text-white/90">
                <Icon name="Check" size={16} className="text-white mr-2" />
                <span className="text-sm">{feature}</span>
              </div>
            ))}
          </div>

          {/* Stats */}
          <div className="grid grid-cols-1 sm:grid-cols-3 gap-8 max-w-2xl mx-auto">
            {stats?.map((stat, index) => (
              <div key={index} className="text-center">
                <div className="text-3xl font-bold text-white mb-2">
                  {stat?.value}
                </div>
                <div className="text-white/80 text-sm">
                  {stat?.label}
                </div>
              </div>
            ))}
          </div>
        </div>

        {/* Bottom Section */}
        <div className="mt-16 pt-8 border-t border-white/20">
          <div className="flex flex-col lg:flex-row items-center justify-between gap-6">
            <div className="flex items-center space-x-6">
              <div className="flex items-center text-white/90">
                <Icon name="Shield" size={20} className="mr-2" />
                <span className="text-sm">Enterprise-grade security</span>
              </div>
              <div className="flex items-center text-white/90">
                <Icon name="Zap" size={20} className="mr-2" />
                <span className="text-sm">99.9% uptime guarantee</span>
              </div>
              <div className="flex items-center text-white/90">
                <Icon name="HeadphonesIcon" size={20} className="mr-2" />
                <span className="text-sm">24/7 support</span>
              </div>
            </div>

            <div className="flex items-center space-x-4 text-white/80 text-sm">
              <span>Questions?</span>
              <Button 
                variant="ghost" 
                size="sm"
                className="text-white hover:text-white hover:bg-white/10"
              >
                Contact Sales
              </Button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CTASection;