import React, { useState } from 'react';
import Image from '../../../components/AppImage';
import Icon from '../../../components/AppIcon';

const VideoTestimonials = () => {
  const [hoveredVideo, setHoveredVideo] = useState(null);

  const testimonials = [
    {
      id: 1,
      name: "Sarah Chen",
      role: "Social Media Manager",
      company: "TechFlow Solutions",
      thumbnail: "https://images.unsplash.com/photo-1494790108755-2616b612b786?w=400&h=300&fit=crop&crop=face",
      videoUrl: "#",
      duration: "2:34",
      quote: "Social Composer Pro transformed our content workflow completely. We\'re now publishing 3x more content with half the effort.",
      metrics: "300% increase in content output"
    },
    {
      id: 2,
      name: "Marcus Rodriguez",
      role: "Creative Director",
      company: "Bright Ideas Agency",
      thumbnail: "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=400&h=300&fit=crop&crop=face",
      videoUrl: "#",
      duration: "3:12",
      quote: "The collaborative features are game-changing. Our team can now work seamlessly across multiple client accounts.",
      metrics: "50% faster project delivery"
    },
    {
      id: 3,
      name: "Emily Watson",
      role: "Content Creator",
      company: "Lifestyle by Emily",
      thumbnail: "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=400&h=300&fit=crop&crop=face",
      videoUrl: "#",
      duration: "1:58",
      quote: "As a solo creator, this platform gives me enterprise-level tools without the complexity. It's perfect.",
      metrics: "200% growth in followers"
    }
  ];

  return (
    <section className="py-16 bg-gradient-to-br from-primary/5 to-secondary/5">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl lg:text-4xl font-bold text-text-primary mb-4">
            Hear From Our Customers
          </h2>
          <p className="text-xl text-text-secondary max-w-3xl mx-auto">
            Real stories from creators, marketers, and teams who've transformed their social media presence with Social Composer Pro.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {testimonials?.map((testimonial) => (
            <div
              key={testimonial?.id}
              className="bg-white rounded-xl creative-confidence-shadow hover:shadow-lg smooth-transition overflow-hidden"
              onMouseEnter={() => setHoveredVideo(testimonial?.id)}
              onMouseLeave={() => setHoveredVideo(null)}
            >
              {/* Video Thumbnail */}
              <div className="relative aspect-video bg-muted overflow-hidden">
                <Image
                  src={testimonial?.thumbnail}
                  alt={`${testimonial?.name} video testimonial`}
                  className="w-full h-full object-cover"
                />
                
                {/* Play Button Overlay */}
                <div className="absolute inset-0 flex items-center justify-center bg-black/20">
                  <div className={`w-16 h-16 bg-white rounded-full flex items-center justify-center smooth-transition ${
                    hoveredVideo === testimonial?.id ? 'scale-110 bg-primary text-white' : 'text-primary'
                  }`}>
                    <Icon name="Play" size={24} className="ml-1" />
                  </div>
                </div>

                {/* Duration Badge */}
                <div className="absolute bottom-3 right-3 bg-black/70 text-white px-2 py-1 rounded text-sm">
                  {testimonial?.duration}
                </div>

                {/* Hover Effect */}
                <div className={`absolute inset-0 bg-primary/10 smooth-transition ${
                  hoveredVideo === testimonial?.id ? 'opacity-100' : 'opacity-0'
                }`} />
              </div>

              {/* Content */}
              <div className="p-6">
                {/* Quote */}
                <blockquote className="text-text-primary mb-4 leading-relaxed">
                  "{testimonial?.quote}"
                </blockquote>

                {/* Metrics */}
                <div className="bg-success/10 text-success px-3 py-2 rounded-lg text-sm font-medium mb-4 inline-block">
                  {testimonial?.metrics}
                </div>

                {/* Author Info */}
                <div className="flex items-center gap-3">
                  <div className="w-12 h-12 rounded-full overflow-hidden bg-muted">
                    <Image
                      src={testimonial?.thumbnail}
                      alt={testimonial?.name}
                      className="w-full h-full object-cover"
                    />
                  </div>
                  <div>
                    <div className="font-semibold text-text-primary">
                      {testimonial?.name}
                    </div>
                    <div className="text-text-secondary text-sm">
                      {testimonial?.role}
                    </div>
                    <div className="text-text-secondary text-sm">
                      {testimonial?.company}
                    </div>
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* CTA */}
        <div className="text-center mt-12">
          <p className="text-text-secondary mb-6">
            Ready to create your own success story?
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button className="px-8 py-3 bg-primary text-white rounded-lg font-semibold hover:bg-primary/90 smooth-transition">
              Start Free Trial
            </button>
            <button className="px-8 py-3 border border-border text-text-primary rounded-lg font-semibold hover:bg-muted smooth-transition">
              Schedule Demo
            </button>
          </div>
        </div>
      </div>
    </section>
  );
};

export default VideoTestimonials;