import React from 'react';
import Icon from '../../../components/AppIcon';

const StatsOverview = () => {
  const stats = [
    {
      icon: 'Users',
      value: '10,000+',
      label: 'Happy Customers',
      description: 'Creators and teams worldwide',
      color: 'text-blue-600'
    },
    {
      icon: 'FileText',
      value: '2.5M+',
      label: 'Posts Published',
      description: 'Across all social platforms',
      color: 'text-green-600'
    },
    {
      icon: 'Clock',
      value: '150,000+',
      label: 'Hours Saved',
      description: 'In content creation time',
      color: 'text-purple-600'
    },
    {
      icon: 'TrendingUp',
      value: '300%',
      label: 'Average Growth',
      description: 'In engagement rates',
      color: 'text-orange-600'
    },
    {
      icon: 'Star',
      value: '4.9/5',
      label: 'Customer Rating',
      description: 'Based on 2,000+ reviews',
      color: 'text-yellow-600'
    },
    {
      icon: 'Globe',
      value: '50+',
      label: 'Countries',
      description: 'Using our platform',
      color: 'text-indigo-600'
    }
  ];

  return (
    <section className="py-16 bg-gradient-to-br from-primary/5 via-white to-secondary/5">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl lg:text-4xl font-bold text-text-primary mb-4">
            Trusted by Creators Worldwide
          </h2>
          <p className="text-xl text-text-secondary max-w-3xl mx-auto">
            Join thousands of successful creators, marketers, and teams who've transformed their social media presence with Social Composer Pro.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {stats?.map((stat, index) => (
            <div
              key={index}
              className="bg-white rounded-xl creative-confidence-shadow hover:shadow-lg smooth-transition p-8 text-center group"
            >
              {/* Icon */}
              <div className={`w-16 h-16 mx-auto mb-4 rounded-full bg-gray-50 flex items-center justify-center group-hover:scale-110 smooth-transition ${stat?.color}`}>
                <Icon name={stat?.icon} size={32} />
              </div>

              {/* Value */}
              <div className="text-4xl font-bold text-text-primary mb-2">
                {stat?.value}
              </div>

              {/* Label */}
              <div className="text-lg font-semibold text-text-primary mb-2">
                {stat?.label}
              </div>

              {/* Description */}
              <div className="text-text-secondary">
                {stat?.description}
              </div>
            </div>
          ))}
        </div>

        {/* Additional Context */}
        <div className="mt-16 text-center">
          <div className="bg-white rounded-xl creative-confidence-shadow p-8 max-w-4xl mx-auto">
            <div className="grid md:grid-cols-3 gap-8 items-center">
              <div className="text-center">
                <div className="text-2xl font-bold text-primary mb-2">99.9%</div>
                <div className="text-text-secondary">Uptime Guarantee</div>
              </div>
              <div className="text-center">
                <div className="text-2xl font-bold text-secondary mb-2">24/7</div>
                <div className="text-text-secondary">Customer Support</div>
              </div>
              <div className="text-center">
                <div className="text-2xl font-bold text-success mb-2">30-Day</div>
                <div className="text-text-secondary">Money-Back Guarantee</div>
              </div>
            </div>
          </div>
        </div>

        {/* Trust Badges */}
        <div className="mt-12 text-center">
          <p className="text-text-secondary mb-6">Trusted by leading brands and agencies</p>
          <div className="flex flex-wrap justify-center items-center gap-8 opacity-60">
            <div className="text-2xl font-bold text-text-secondary">TechCrunch</div>
            <div className="text-2xl font-bold text-text-secondary">Forbes</div>
            <div className="text-2xl font-bold text-text-secondary">Mashable</div>
            <div className="text-2xl font-bold text-text-secondary">Wired</div>
            <div className="text-2xl font-bold text-text-secondary">Fast Company</div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default StatsOverview;