import React from 'react';
import Image from '../../../components/AppImage';
import Icon from '../../../components/AppIcon';

const CustomerQuotes = () => {
  const quotes = [
    {
      id: 1,
      text: "Social Composer Pro didn\'t just improve our workflow—it completely transformed how we think about content creation. The creative confidence it gives our team is invaluable.",
      author: "Jennifer Martinez",
      role: "Head of Digital Marketing",
      company: "GrowthLab Inc.",
      avatar: "https://images.unsplash.com/photo-1494790108755-2616b612b786?w=100&h=100&fit=crop&crop=face",
      metrics: "400% increase in content output",
      industry: "SaaS"
    },
    {
      id: 2,
      text: "As a solo creator, I was drowning in the complexity of managing multiple platforms. This tool gave me back my creativity and my sanity. It's like having a whole team behind me.",
      author: "David Kim",
      role: "Content Creator & Influencer",
      company: "Tech Talks with David",
      avatar: "https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=100&h=100&fit=crop&crop=face",
      metrics: "250% follower growth in 6 months",
      industry: "Content Creator"
    },
    {
      id: 3,
      text: "The collaborative features revolutionized how our agency works with clients. We can now deliver premium social media strategies at scale without sacrificing quality.",
      author: "Lisa Thompson",
      role: "Agency Owner",
      company: "Creative Collective",
      avatar: "https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=100&h=100&fit=crop&crop=face",
      metrics: "60% faster client delivery",
      industry: "Marketing Agency"
    },
    {
      id: 4,
      text: "We went from posting sporadically to having a consistent, professional presence across all platforms. The analytics help us understand what resonates with our audience.",
      author: "Michael Chen",
      role: "Marketing Director",
      company: "EcoTech Solutions",
      avatar: "https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=100&h=100&fit=crop&crop=face",
      metrics: "180% increase in engagement",
      industry: "E-commerce"
    },
    {
      id: 5,
      text: "The time savings alone justify the investment, but the quality improvement in our content is what really sets this platform apart. Our brand voice is now consistent everywhere.",
      author: "Rachel Adams",
      role: "Brand Manager",
      company: "Wellness Warriors",
      avatar: "https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=100&h=100&fit=crop&crop=face",
      metrics: "15 hours saved per week",
      industry: "Healthcare"
    },
    {
      id: 6,
      text: "Social Composer Pro bridges the gap between enterprise functionality and user-friendly design. It\'s sophisticated enough for our needs but simple enough for our entire team to use.",
      author: "James Wilson",
      role: "VP of Marketing",
      company: "InnovateTech",
      avatar: "https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=100&h=100&fit=crop&crop=face",
      metrics: "300% ROI in first quarter",
      industry: "SaaS"
    }
  ];

  const getIndustryColor = (industry) => {
    const colors = {
      'Marketing Agency': 'bg-blue-100 text-blue-700',
      'E-commerce': 'bg-green-100 text-green-700',
      'SaaS': 'bg-purple-100 text-purple-700',
      'Content Creator': 'bg-pink-100 text-pink-700',
      'Healthcare': 'bg-red-100 text-red-700'
    };
    return colors?.[industry] || 'bg-gray-100 text-gray-700';
  };

  return (
    <section className="py-16 bg-muted/30">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-12">
          <h2 className="text-3xl lg:text-4xl font-bold text-text-primary mb-4">
            What Our Customers Say
          </h2>
          <p className="text-xl text-text-secondary max-w-3xl mx-auto">
            Authentic feedback from creators, marketers, and teams who've experienced the creative confidence that comes with the right tools.
          </p>
        </div>

        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
          {quotes?.map((quote) => (
            <div
              key={quote?.id}
              className="bg-white rounded-xl creative-confidence-shadow hover:shadow-lg smooth-transition p-6 relative"
            >
              {/* Quote Icon */}
              <div className="absolute -top-3 -left-3 w-8 h-8 bg-primary rounded-full flex items-center justify-center">
                <Icon name="Quote" size={16} color="white" />
              </div>

              {/* Industry Badge */}
              <div className="flex justify-end mb-4">
                <span className={`px-3 py-1 rounded-full text-xs font-medium ${getIndustryColor(quote?.industry)}`}>
                  {quote?.industry}
                </span>
              </div>

              {/* Quote Text */}
              <blockquote className="text-text-primary leading-relaxed mb-6 italic">
                "{quote?.text}"
              </blockquote>

              {/* Metrics */}
              <div className="bg-success/10 text-success px-3 py-2 rounded-lg text-sm font-medium mb-4 inline-block">
                <Icon name="TrendingUp" size={14} className="inline mr-1" />
                {quote?.metrics}
              </div>

              {/* Author Info */}
              <div className="flex items-center gap-3">
                <div className="w-12 h-12 rounded-full overflow-hidden bg-muted flex-shrink-0">
                  <Image
                    src={quote?.avatar}
                    alt={quote?.author}
                    className="w-full h-full object-cover"
                  />
                </div>
                <div>
                  <div className="font-semibold text-text-primary">
                    {quote?.author}
                  </div>
                  <div className="text-text-secondary text-sm">
                    {quote?.role}
                  </div>
                  <div className="text-text-secondary text-sm">
                    {quote?.company}
                  </div>
                </div>
              </div>
            </div>
          ))}
        </div>

        {/* Bottom CTA */}
        <div className="text-center mt-12">
          <div className="bg-white rounded-xl creative-confidence-shadow p-8 max-w-2xl mx-auto">
            <h3 className="text-2xl font-bold text-text-primary mb-4">
              Ready to Join These Success Stories?
            </h3>
            <p className="text-text-secondary mb-6">
              Start your free trial today and experience the creative confidence that comes with professional-grade social media tools.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center">
              <button className="px-8 py-3 bg-primary text-white rounded-lg font-semibold hover:bg-primary/90 smooth-transition flex items-center justify-center gap-2">
                <Icon name="Zap" size={20} />
                Start Free Trial
              </button>
              <button className="px-8 py-3 border border-border text-text-primary rounded-lg font-semibold hover:bg-muted smooth-transition flex items-center justify-center gap-2">
                <Icon name="Calendar" size={20} />
                Schedule Demo
              </button>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default CustomerQuotes;