import React from 'react';
import { Twitter, Instagram, Linkedin } from 'lucide-react';
import Icon from '../../../components/AppIcon';


const PlatformPreview = ({ content, activeTab, setActiveTab, selectedPlatforms }) => {
  const platforms = [
    { id: 'twitter', name: 'X', icon: Twitter, color: 'text-black' },
    { id: 'instagram', name: 'Instagram', icon: Instagram, color: 'text-pink-600' },
    { id: 'linkedin', name: 'LinkedIn', icon: Linkedin, color: 'text-blue-600' }
  ];

  const getPreviewContent = (platformId) => {
    let previewContent = content;
    
    // Platform-specific formatting
    switch (platformId) {
      case 'twitter':
        if (previewContent?.length > 280) {
          previewContent = previewContent?.substring(0, 277) + '...';
        }
        break;
      case 'instagram':
        // Instagram allows longer posts but shows preview
        break;
      case 'linkedin':
        // LinkedIn professional formatting
        break;
    }
    
    return previewContent;
  };

  const renderPreview = (platformId) => {
    let previewContent = getPreviewContent(platformId);
    
    switch (platformId) {
      case 'twitter':
        return (
          <div className="bg-white border border-gray-200 rounded-lg p-4">
            <div className="flex items-start space-x-3">
              <div className="w-10 h-10 bg-gray-300 rounded-full flex-shrink-0"></div>
              <div className="flex-1">
                <div className="flex items-center space-x-2 mb-1">
                  <span className="font-semibold text-sm">Your Account</span>
                  <span className="text-gray-500 text-sm">@youraccount</span>
                  <span className="text-gray-500 text-sm">·</span>
                  <span className="text-gray-500 text-sm">now</span>
                </div>
                <div className="text-sm text-gray-900">
                  {previewContent || 'Your post preview will appear here...'}
                </div>
              </div>
            </div>
          </div>
        );
      
      case 'instagram':
        return (
          <div className="bg-white border border-gray-200 rounded-lg">
            <div className="p-3 flex items-center space-x-2 border-b border-gray-200">
              <div className="w-8 h-8 bg-gray-300 rounded-full"></div>
              <span className="font-semibold text-sm">youraccount</span>
            </div>
            <div className="aspect-square bg-gray-100 flex items-center justify-center text-gray-500">
              Photo/Video Preview
            </div>
            <div className="p-3">
              <div className="text-sm text-gray-900">
                <span className="font-semibold">youraccount</span>{' '}
                {previewContent || 'Your caption will appear here...'}
              </div>
            </div>
          </div>
        );
      
      case 'linkedin':
        return (
          <div className="bg-white border border-gray-200 rounded-lg">
            <div className="p-4 border-b border-gray-200">
              <div className="flex items-center space-x-3">
                <div className="w-10 h-10 bg-blue-600 rounded-full"></div>
                <div>
                  <div className="font-semibold text-sm">Your Name</div>
                  <div className="text-xs text-gray-500">Your Professional Title</div>
                  <div className="text-xs text-gray-500">now</div>
                </div>
              </div>
            </div>
            <div className="p-4">
              <div className="text-sm text-gray-900">
                {previewContent || 'Your professional post will appear here...'}
              </div>
            </div>
          </div>
        );
      
      default:
        return null;
    }
  };

  const activePlatforms = platforms?.filter(p => selectedPlatforms?.[p?.id]);

  return (
    <div>
      <h3 className="text-sm font-medium text-gray-900 mb-3">Platform Preview</h3>
      {/* Platform Tabs */}
      <div className="flex space-x-1 mb-4">
        {activePlatforms?.map((platform) => {
          const Icon = platform?.icon;
          return (
            <button
              key={platform?.id}
              onClick={() => setActiveTab(platform?.id)}
              className={`
                flex items-center space-x-2 px-3 py-2 rounded-lg text-sm font-medium transition-colors
                ${activeTab === platform?.id 
                  ? 'bg-blue-100 text-blue-700' :'text-gray-600 hover:text-gray-900 hover:bg-gray-100'
                }
              `}
            >
              <Icon className={`w-4 h-4 ${platform?.color}`} />
              <span>{platform?.name}</span>
            </button>
          );
        })}
      </div>
      {/* Preview Content */}
      <div className="space-y-4">
        {activePlatforms?.length > 0 ? (
          renderPreview(activeTab)
        ) : (
          <div className="text-center py-8 text-gray-500">
            <p>Select platforms to see preview</p>
          </div>
        )}
      </div>
    </div>
  );
};

export default PlatformPreview;