import React from 'react';
import { Twitter, Instagram, Linkedin, Check } from 'lucide-react';
import Icon from '../../../components/AppIcon';


const PlatformControls = ({ selectedPlatforms, setSelectedPlatforms }) => {
  const platforms = [
    { 
      id: 'twitter', 
      name: 'X (Twitter)', 
      icon: Twitter, 
      color: 'border-black', 
      bgColor: 'bg-black',
      description: '280 characters, trending hashtags'
    },
    { 
      id: 'instagram', 
      name: 'Instagram', 
      icon: Instagram, 
      color: 'border-pink-500', 
      bgColor: 'bg-pink-500',
      description: '2,200 characters, visual-first content'
    },
    { 
      id: 'linkedin', 
      name: 'LinkedIn', 
      icon: Linkedin, 
      color: 'border-blue-600', 
      bgColor: 'bg-blue-600',
      description: '3,000 characters, professional network'
    }
  ];

  const togglePlatform = (platformId) => {
    setSelectedPlatforms(prev => ({
      ...prev,
      [platformId]: !prev?.[platformId]
    }));
  };

  return (
    <div>
      <h3 className="text-sm font-medium text-gray-900 mb-3">Publishing Platforms</h3>
      <div className="space-y-3">
        {platforms?.map((platform) => {
          const Icon = platform?.icon;
          const isSelected = selectedPlatforms?.[platform?.id];
          
          return (
            <div
              key={platform?.id}
              onClick={() => togglePlatform(platform?.id)}
              className={`
                relative cursor-pointer border-2 rounded-lg p-4 transition-all
                ${isSelected 
                  ? `${platform?.color} bg-gray-50` 
                  : 'border-gray-200 hover:border-gray-300'
                }
              `}
            >
              <div className="flex items-start justify-between">
                <div className="flex items-center space-x-3 flex-1">
                  <div className={`
                    w-10 h-10 rounded-lg flex items-center justify-center
                    ${isSelected ? platform?.bgColor : 'bg-gray-100'}
                  `}>
                    <Icon className={`w-5 h-5 ${isSelected ? 'text-white' : 'text-gray-600'}`} />
                  </div>
                  
                  <div className="flex-1">
                    <div className="font-medium text-gray-900">{platform?.name}</div>
                    <div className="text-xs text-gray-500 mt-1">{platform?.description}</div>
                  </div>
                </div>
                
                {/* Selection Indicator */}
                <div className={`
                  w-5 h-5 rounded-full border-2 flex items-center justify-center transition-colors
                  ${isSelected 
                    ? 'bg-green-500 border-green-500' :'border-gray-300'
                  }
                `}>
                  {isSelected && <Check className="w-3 h-3 text-white" />}
                </div>
              </div>
              {/* Platform-specific options */}
              {isSelected && (
                <div className="mt-3 pt-3 border-t border-gray-200">
                  <div className="space-y-2">
                    {platform?.id === 'twitter' && (
                      <>
                        <label className="flex items-center text-sm">
                          <input type="checkbox" className="rounded border-gray-300 mr-2" />
                          Add to thread
                        </label>
                        <label className="flex items-center text-sm">
                          <input type="checkbox" className="rounded border-gray-300 mr-2" />
                          Enable replies
                        </label>
                      </>
                    )}
                    
                    {platform?.id === 'instagram' && (
                      <>
                        <label className="flex items-center text-sm">
                          <input type="checkbox" className="rounded border-gray-300 mr-2" />
                          Post to Stories
                        </label>
                        <label className="flex items-center text-sm">
                          <input type="checkbox" className="rounded border-gray-300 mr-2" />
                          Enable comments
                        </label>
                      </>
                    )}
                    
                    {platform?.id === 'linkedin' && (
                      <>
                        <label className="flex items-center text-sm">
                          <input type="checkbox" className="rounded border-gray-300 mr-2" />
                          Notify network
                        </label>
                        <label className="flex items-center text-sm">
                          <input type="checkbox" className="rounded border-gray-300 mr-2" />
                          Professional tone check
                        </label>
                      </>
                    )}
                  </div>
                </div>
              )}
            </div>
          );
        })}
      </div>
      {/* Quick Actions */}
      <div className="mt-4 pt-4 border-t border-gray-200">
        <div className="flex space-x-2">
          <button 
            onClick={() => setSelectedPlatforms({ twitter: true, instagram: true, linkedin: true })}
            className="flex-1 px-3 py-2 text-xs bg-blue-50 text-blue-700 rounded-lg hover:bg-blue-100"
          >
            Select All
          </button>
          <button 
            onClick={() => setSelectedPlatforms({ twitter: false, instagram: false, linkedin: false })}
            className="flex-1 px-3 py-2 text-xs bg-gray-50 text-gray-700 rounded-lg hover:bg-gray-100"
          >
            Clear All
          </button>
        </div>
      </div>
    </div>
  );
};

export default PlatformControls;