import React from 'react';
import { AlertTriangle, CheckCircle, XCircle } from 'lucide-react';
import Icon from '../../../components/AppIcon';


const CharacterCounter = ({ platform, count, limit }) => {
  const percentage = (count / limit) * 100;
  const isWarning = percentage >= 80;
  const isOver = count > limit;
  
  const getStatusColor = () => {
    if (isOver) return 'text-red-600';
    if (isWarning) return 'text-amber-600';
    return 'text-green-600';
  };
  
  const getProgressColor = () => {
    if (isOver) return 'bg-red-500';
    if (isWarning) return 'bg-amber-500';
    return 'bg-green-500';
  };
  
  const getIcon = () => {
    if (isOver) return XCircle;
    if (isWarning) return AlertTriangle;
    return CheckCircle;
  };
  
  const Icon = getIcon();
  
  const platformNames = {
    twitter: 'X',
    instagram: 'Instagram',
    linkedin: 'LinkedIn'
  };

  return (
    <div className="bg-gray-50 rounded-lg p-3">
      <div className="flex items-center justify-between mb-2">
        <div className="flex items-center space-x-2">
          <span className="text-sm font-medium text-gray-700">
            {platformNames?.[platform]}
          </span>
          <Icon className={`w-4 h-4 ${getStatusColor()}`} />
        </div>
        <div className={`text-sm font-mono ${getStatusColor()}`}>
          {count}/{limit}
        </div>
      </div>
      {/* Progress Bar */}
      <div className="w-full bg-gray-200 rounded-full h-2">
        <div 
          className={`h-2 rounded-full transition-all duration-300 ${getProgressColor()}`}
          style={{ width: `${Math.min(percentage, 100)}%` }}
        ></div>
      </div>
      {/* Warning Messages */}
      {isOver && (
        <div className="mt-2 text-xs text-red-600 flex items-center space-x-1">
          <AlertTriangle className="w-3 h-3" />
          <span>Content exceeds {platform} character limit</span>
        </div>
      )}
      {isWarning && !isOver && (
        <div className="mt-2 text-xs text-amber-600 flex items-center space-x-1">
          <AlertTriangle className="w-3 h-3" />
          <span>Approaching character limit</span>
        </div>
      )}
      {/* Remaining characters for close calls */}
      {!isOver && percentage >= 70 && (
        <div className="mt-1 text-xs text-gray-500">
          {limit - count} characters remaining
        </div>
      )}
    </div>
  );
};

export default CharacterCounter;