import React from "react";
import { BrowserRouter, Routes as RouterRoutes, Route } from "react-router-dom";
import ScrollToTop from "./components/ScrollToTop";
import ErrorBoundary from "./components/ErrorBoundary";
import NotFound from "./pages/NotFound";
import PricingPage from './pages/pricing';
import Resources from './pages/resources';
import SignUpPage from './pages/sign-up';
import ProductFeatures from './pages/product-features';
import CustomerStories from './pages/customer-stories';
import Homepage from './pages/homepage';
import ComposerInterface from './pages/composer-interface';

const Routes = () => {
  
  return (
    <BrowserRouter>
      <ErrorBoundary>
      <ScrollToTop />
      <RouterRoutes>
        {/* Define your route here */}
        <Route path="/" element={<Homepage />} />
        <Route path="/homepage" element={<Homepage />} />
        <Route path="/pricing" element={<PricingPage />} />
        <Route path="/resources" element={<Resources />} />
        <Route path="/sign-up" element={<SignUpPage />} />
        <Route path="/product-features" element={<ProductFeatures />} />
        <Route path="/customer-stories" element={<CustomerStories />} />
        <Route path="/composer-interface" element={<ComposerInterface />} />
        <Route path="*" element={<NotFound />} />
      </RouterRoutes>
      </ErrorBoundary>
    </BrowserRouter>
  );
};

export default Routes;
