import defaultTheme from 'tailwindcss/defaultTheme';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/**/*.blade.php',
        './resources/**/*.js',
        './resources/**/*.vue',
    ],
    darkMode: 'class', // Enable dark mode with class strategy
    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                // TailAdmin color palette using standard Tailwind colors
                primary: {
                    DEFAULT: '#3C50E0',
                    50: '#f0f4ff',
                    100: '#e0e7ff',
                    200: '#c7d2fe',
                    300: '#a5b4fc',
                    400: '#818cf8',
                    500: '#6366f1',
                    600: '#4f46e5',
                    700: '#4338ca',
                    800: '#3730a3',
                    900: '#312e81',
                },
                success: {
                    DEFAULT: '#10B981',
                    50: '#ecfdf5',
                    100: '#d1fae5',
                    200: '#a7f3d0',
                    300: '#6ee7b7',
                    400: '#34d399',
                    500: '#10b981',
                    600: '#059669',
                    700: '#047857',
                    800: '#065f46',
                    900: '#064e3b',
                },
                danger: {
                    DEFAULT: '#F87171',
                    50: '#fef2f2',
                    100: '#fee2e2',
                    200: '#fecaca',
                    300: '#fca5a5',
                    400: '#f87171',
                    500: '#ef4444',
                    600: '#dc2626',
                    700: '#b91c1c',
                    800: '#991b1b',
                    900: '#7f1d1d',
                },
                warning: {
                    DEFAULT: '#F59E0B',
                    50: '#fffbeb',
                    100: '#fef3c7',
                    200: '#fde68a',
                    300: '#fcd34d',
                    400: '#fbbf24',
                    500: '#f59e0b',
                    600: '#d97706',
                    700: '#b45309',
                    800: '#92400e',
                    900: '#78350f',
                },
            },
            fontSize: {
                'title-xxl': ['44px', '55px'],
                'title-xl': ['36px', '45px'],
                'title-xl2': ['33px', '45px'],
                'title-lg': ['28px', '35px'],
                'title-md': ['24px', '30px'],
                'title-md2': ['26px', '30px'],
                'title-sm': ['20px', '26px'],
                'title-xsm': ['18px', '24px'],
            },
            spacing: {
                '4.5': '1.125rem',
                '5.5': '1.375rem',
                '6.5': '1.625rem',
                '7.5': '1.875rem',
                '8.5': '2.125rem',
                '9.5': '2.375rem',
                '10.5': '2.625rem',
                '11': '2.75rem',
                '11.5': '2.875rem',
                '12.5': '3.125rem',
                '13': '3.25rem',
                '13.5': '3.375rem',
                '14': '3.5rem',
                '14.5': '3.625rem',
                '15': '3.75rem',
                '15.5': '3.875rem',
                '16': '4rem',
                '16.5': '4.125rem',
                '17': '4.25rem',
                '17.5': '4.375rem',
                '18': '4.5rem',
                '18.5': '4.625rem',
                '19': '4.75rem',
                '19.5': '4.875rem',
                '21': '5.25rem',
                '21.5': '5.375rem',
                '22': '5.5rem',
                '22.5': '5.625rem',
                '24.5': '6.125rem',
                '25': '6.25rem',
                '25.5': '6.375rem',
                '26': '6.5rem',
                '27': '6.75rem',
                '27.5': '6.875rem',
                '29': '7.25rem',
                '29.5': '7.375rem',
                '30': '7.5rem',
                '31': '7.75rem',
                '32.5': '8.125rem',
                '33': '8.25rem',
                '34': '8.5rem',
                '34.5': '8.625rem',
                '35': '8.75rem',
                '36.5': '9.125rem',
                '37.5': '9.375rem',
                '39': '9.75rem',
                '39.5': '9.875rem',
                '40': '10rem',
                '42.5': '10.625rem',
                '44': '11rem',
                '45': '11.25rem',
                '46': '11.5rem',
                '47.5': '11.875rem',
                '49': '12.25rem',
                '50': '12.5rem',
                '52': '13rem',
                '52.5': '13.125rem',
                '54': '13.5rem',
                '54.5': '13.625rem',
                '55': '13.75rem',
                '55.5': '13.875rem',
                '59': '14.75rem',
                '60': '15rem',
                '62.5': '15.625rem',
                '65': '16.25rem',
                '67': '16.75rem',
                '67.5': '16.875rem',
                '70': '17.5rem',
                '72.5': '18.125rem',
                '73': '18.25rem',
                '75': '18.75rem',
                '90': '22.5rem',
                '94': '23.5rem',
                '95': '23.75rem',
                '100': '25rem',
                '115': '28.75rem',
                '125': '31.25rem',
                '132.5': '33.125rem',
                '150': '37.5rem',
                '171.5': '42.875rem',
                '180': '45rem',
                '192.5': '48.125rem',
                '203': '50.75rem',
                '230': '57.5rem',
                '242.5': '60.625rem',
            },
            maxWidth: {
                '2.5xl': '45rem',
                '4.5xl': '60rem',
            },
            maxHeight: {
                '35': '8.75rem',
                '70': '17.5rem',
                '90': '22.5rem',
            },
            minWidth: {
                '22.5': '5.625rem',
                '42.5': '10.625rem',
                '47.5': '11.875rem',
            },
            zIndex: {
                '999': '999',
                '99': '99',
                '9': '9',
                '1': '1',
            },
            opacity: {
                '65': '.65',
            },
            backgroundImage: {
                'video': "url('../images/video/video.png')",
            },
            boxShadow: {
                'default': '0px 8px 13px -3px rgba(0, 0, 0, 0.07)',
                'card': '0px 1px 3px rgba(0, 0, 0, 0.12)',
                'card-2': '0px 1px 2px rgba(0, 0, 0, 0.05)',
                'switcher': '0px 2px 4px rgba(0, 0, 0, 0.2), inset 0px 2px 2px #FFFFFF, inset 0px -1px 1px rgba(0, 0, 0, 0.1)',
                '1': '0px 0px 20px 0px rgba(0, 0, 0, 0.15)',
                '2': '0px 0px 40px 0px rgba(0, 0, 0, 0.08)',
                '3': '0px 0px 10px 0px rgba(0, 0, 0, 0.08)',
                '4': '0px 8px 10px 0px rgba(0, 0, 0, 0.08)',
                '5': '0px 0px 15px 0px rgba(0, 0, 0, 0.10)',
            },
            dropShadow: {
                '1': '0px 1px 0px #E2E8F0',
                '2': '0px 1px 4px rgba(0, 0, 0, 0.12)',
            },
            keyframes: {
                rotating: {
                    '0%, 100%': { transform: 'rotate(360deg)' },
                    '50%': { transform: 'rotate(0deg)' },
                },
            },
            animation: {
                'spin-slow': 'rotating 10s linear infinite',
            },
        },
    },
    plugins: [],
};
