<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Email Address</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: #ffffff;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #2563eb;
            margin: 0;
            font-size: 24px;
        }
        .content {
            margin-bottom: 30px;
        }
        .content p {
            margin-bottom: 15px;
        }
        .button-container {
            text-align: center;
            margin: 30px 0;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #2563eb;
            color: #ffffff !important;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            transition: background-color 0.3s;
        }
        .button:hover {
            background-color: #1d4ed8;
        }
        .link-container {
            margin-top: 20px;
            padding: 15px;
            background-color: #f3f4f6;
            border-radius: 5px;
            word-break: break-all;
            font-size: 12px;
            color: #6b7280;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            font-size: 12px;
            color: #6b7280;
        }
        .warning {
            background-color: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 12px;
            margin: 20px 0;
            border-radius: 4px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?php echo e(config('app.name', 'Social Platform')); ?></h1>
        </div>
        
        <div class="content">
            <?php if($userName): ?>
                <p>Hello <?php echo e($userName); ?>,</p>
            <?php else: ?>
                <p>Hello,</p>
            <?php endif; ?>
            
            <p>Thank you for registering with <?php echo e(config('app.name', 'Social Platform')); ?>! To complete your registration and activate your account, please verify your email address by clicking the button below.</p>
            
            <div class="button-container">
                <a href="<?php echo e($verificationUrl); ?>" class="button">Verify Email Address</a>
            </div>
            
            <p>If the button doesn't work, you can copy and paste the following link into your browser:</p>
            
            <div class="link-container">
                <?php echo e($verificationUrl); ?>

            </div>
            
            <div class="warning">
                <strong>Important:</strong> This verification link will expire in 24 hours. If you didn't create an account with us, please ignore this email.
            </div>
            
            <p>Once you verify your email, your account will be activated and you'll be able to log in and complete your profile.</p>
        </div>
        
        <div class="footer">
            <p>This is an automated email, please do not reply.</p>
            <p>&copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.name', 'Social Platform')); ?>. All rights reserved.</p>
        </div>
    </div>
</body>
</html>

<?php /**PATH /var/www/html/social-platform/resources/views/emails/verify-email.blade.php ENDPATH**/ ?>