<div class="flex items-center gap-1 whitespace-nowrap">
    <button onclick="openViewCategoryModal(<?php echo e($category->id); ?>)" title="View" aria-label="View category" class="inline-flex items-center p-2 text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white">
        <i class="fa-solid fa-eye"></i>
    </button>
    <button onclick="openEditCategoryModal(<?php echo e($category->id); ?>)" title="Edit" aria-label="Edit category" class="inline-flex items-center p-2 text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white">
        <i class="fa-solid fa-pen"></i>
    </button>
    <form action="<?php echo e(route('categories.destroy', $category->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this category?');">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" title="Delete" aria-label="Delete category" class="inline-flex items-center p-2 text-red-600 hover:text-red-700 dark:text-red-400 dark:hover:text-red-300">
            <i class="fa-solid fa-trash"></i>
        </button>
    </form>
</div>

<?php /**PATH /var/www/html/social-platform/resources/views/admin/categories/partials/actions.blade.php ENDPATH**/ ?>