

<?php $__env->startSection('title', 'Categories'); ?>

<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="p-4 mx-auto max-w-(--breakpoint-2xl) md:p-6">
        <div class="grid grid-cols-12 gap-4 md:gap-6">
            <div class="col-span-12 xl:col-span-12">
                <div class="overflow-hidden rounded-2xl border border-gray-200 bg-white px-4 pb-3 pt-4 dark:border-gray-800 dark:bg-white/[0.03] sm:px-6">
                    <div class="flex flex-col gap-2 mb-4 sm:flex-row sm:items-center sm:justify-between">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">
                                Categories
                            </h3>
                        </div>

                        <div class="flex items-center gap-3">
                            <button class="inline-flex items-center gap-2 rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-theme-sm font-medium text-gray-700 shadow-theme-xs hover:bg-gray-50 hover:text-gray-800 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200">
                                <svg
                                class="stroke-current fill-white dark:fill-gray-800"
                                width="20"
                                height="20"
                                viewBox="0 0 20 20"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                                >
                                <path
                                    d="M2.29004 5.90393H17.7067"
                                    stroke=""
                                    stroke-width="1.5"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M17.7075 14.0961H2.29085"
                                    stroke=""
                                    stroke-width="1.5"
                                    stroke-linecap="round"
                                    stroke-linejoin="round"
                                />
                                <path
                                    d="M12.0826 3.33331C13.5024 3.33331 14.6534 4.48431 14.6534 5.90414C14.6534 7.32398 13.5024 8.47498 12.0826 8.47498C10.6627 8.47498 9.51172 7.32398 9.51172 5.90415C9.51172 4.48432 10.6627 3.33331 12.0826 3.33331Z"
                                    fill=""
                                    stroke=""
                                    stroke-width="1.5"
                                />
                                <path
                                    d="M7.91745 11.525C6.49762 11.525 5.34662 12.676 5.34662 14.0959C5.34661 15.5157 6.49762 16.6667 7.91745 16.6667C9.33728 16.6667 10.4883 15.5157 10.4883 14.0959C10.4883 12.676 9.33728 11.525 7.91745 11.525Z"
                                    fill=""
                                    stroke=""
                                    stroke-width="1.5"
                                />
                                </svg>

                                Filter
                            </button>

                            <button class="inline-flex items-center gap-2 rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-theme-sm font-medium text-gray-700 shadow-theme-xs hover:bg-gray-50 hover:text-gray-800 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200" onclick="openCategoryModal('create')">
                                Create Category
                            </button>
                        </div>
                    </div>

                    <div class="w-full overflow-x-visible">
                    <table id="example" class="display w-full break-words">
        <thead>
            <tr>
                <th>Category Name</th>
                <th>Is Default</th>
                <th>User ID</th>
                <th>Created</th>
                <th data-orderable="false">Actions</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
        
    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

   
    <?php echo $__env->make('admin.categories.partials.create-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.categories.partials.view-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.categories.partials.edit-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


    <!-- Modal JS (basic, you can enhance with Alpine.js or Vue) -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof DataTable !== 'undefined') {
                
                new DataTable('#example', {
    processing: true,
    serverSide: true,
    ajax: {
        url: '<?php echo e(route('categories.data')); ?>',
        type: 'GET'
    },
    columns: [
        { data: 'name', name: 'category_name' },
        { data: 'is_default', name: 'is_default' },
        { data: 'user_id', name: 'user_id' },
        { data: 'created', name: 'created_at' },
        { data: 'actions', name: 'actions', orderable: false, searchable: false }
    ],
    responsive: true,
    columnDefs: [
        { orderable: false, targets: -1 }
    ],
    layout: {
       
        topEnd: {
            search: {
                placeholder: 'Search categories...'
            }
        },
        bottomStart: null,
        bottomEnd: {
            paging: {
                first: false,
                last: false,
                previous: false,
                next: false
            }
        }
    },
    language: {
        search: "",
        searchPlaceholder: "Search categories...",
        lengthMenu: "Show _MENU_ entries",
        info: "Showing _START_ to _END_ of _TOTAL_ entries",
        paginate: {
            first: "First",
            last: "Last", 
            next: "Next",
            previous: "Previous"
        }
    }
});
            }

        });
    </script>

</div>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/social-platform/resources/views/admin/categories/index.blade.php ENDPATH**/ ?>