<!-- View App User Modal -->
<div id="viewAppUserModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closeViewAppUserModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-5xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">App User Details</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300" onclick="closeViewAppUserModal()">
                <i class="fa-solid fa-times"></i>
            </button>
        </div>
        <div class="overflow-auto max-h-[80vh]">
            <div id="appUserDataContainer" class="space-y-6">
                <div class="text-center py-8">
                    <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900 dark:border-white"></div>
                    <p class="mt-2 text-gray-600 dark:text-gray-400">Loading app user data...</p>
                </div>
            </div>
        </div>
        <div class="mt-6 flex items-center justify-end gap-3">
            <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-300" onclick="closeViewAppUserModal()">Close</button>
        </div>
    </div>
</div>

<script>
    window.openViewAppUserModal = function(userId) {
        const modal = document.getElementById('viewAppUserModal');
        const dataContainer = document.getElementById('appUserDataContainer');
        
        // Show modal with loading state
        dataContainer.innerHTML = `
            <div class="text-center py-8">
                <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900 dark:border-white"></div>
                <p class="mt-2 text-gray-600 dark:text-gray-400">Loading app user data...</p>
            </div>
        `;
        modal.classList.remove('hidden');
        
        // Fetch user data
        fetch(`/admin/appusers/${userId}`)
            .then(response => response.json())
            .then(data => {
                const user = data.user;
                const subscription = data.subscription;
                
                // Format dates
                const createdDate = user.created_at ? new Date(user.created_at).toLocaleString() : 'N/A';
                const updatedDate = user.updated_at ? new Date(user.updated_at).toLocaleString() : 'N/A';
                const startDate = subscription && subscription.start_date ? new Date(subscription.start_date).toLocaleDateString() : 'N/A';
                const endDate = subscription && subscription.end_date ? new Date(subscription.end_date).toLocaleDateString() : 'N/A';
                const businessDate = user.business_established_date ? new Date(user.business_established_date).toLocaleDateString() : 'N/A';
                
                // Format social_media_handles - parse JSON object and display as "Platform: Handle"
                let socialHandles = 'N/A';
                if (user.social_media_handles) {
                    try {
                        const parsed = typeof user.social_media_handles === 'string' ? JSON.parse(user.social_media_handles) : user.social_media_handles;
                        if (typeof parsed === 'object' && parsed !== null && !Array.isArray(parsed)) {
                            // It's an object with key-value pairs
                            const entries = Object.entries(parsed)
                                .filter(([key, value]) => value)
                                .map(([key, value]) => `${key.charAt(0).toUpperCase() + key.slice(1)}: ${value}`);
                            socialHandles = entries.length > 0 ? entries.join(', ') : 'N/A';
                        } else if (Array.isArray(parsed)) {
                            // Fallback for array format
                            socialHandles = parsed.filter(item => item).join(', ');
                        } else {
                            socialHandles = 'N/A';
                        }
                    } catch(e) {
                        socialHandles = user.social_media_handles;
                    }
                }
                
                // Format preferred_social_platforms - parse JSON array and display as comma-separated
                let preferredPlatforms = 'N/A';
                if (user.preferred_social_platforms) {
                    try {
                        const parsed = typeof user.preferred_social_platforms === 'string' ? JSON.parse(user.preferred_social_platforms) : user.preferred_social_platforms;
                        preferredPlatforms = Array.isArray(parsed) ? parsed.filter(item => item).join(', ') : 'N/A';
                    } catch(e) {
                        preferredPlatforms = user.preferred_social_platforms;
                    }
                }
                
                // Build subscription section
                let subscriptionHtml = '';
                if (subscription) {
                    subscriptionHtml = `
                        <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-6">
                            <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Subscription Details</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Subscription ID</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${subscription.id || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Plan</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${subscription.plan ? escapeHtml(subscription.plan.name) : 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Start Date</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${startDate}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">End Date</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${endDate}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Status</label>
                                    <p class="mt-1">
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${getSubscriptionStatusColor(subscription.status)}">
                                            ${escapeHtml(subscription.status ? subscription.status.charAt(0).toUpperCase() + subscription.status.slice(1) : 'N/A')}
                                        </span>
                                    </p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Payment Method</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(subscription.payment_method || 'N/A')}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700 md:col-span-2">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Transaction ID</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(subscription.transaction_id || 'N/A')}</p>
                                </div>
                            </div>
                        </div>
                    `;
                } else {
                    subscriptionHtml = `
                        <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-6">
                            <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Subscription Details</h4>
                            <p class="text-sm text-gray-600 dark:text-gray-400">No subscription found for this user.</p>
                        </div>
                    `;
                }
                
                // Format and display as HTML
                dataContainer.innerHTML = `
                    <div>
                        <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Basic Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">ID</label>
                                <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${user.id || 'N/A'}</p>
                            </div>
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Name</label>
                                <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.name) || 'N/A'}</p>
                            </div>
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Email</label>
                                <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.email) || 'N/A'}</p>
                            </div>
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Timezone</label>
                                <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.timezone) || 'N/A'}</p>
                            </div>
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Status</label>
                                <p class="mt-1">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${getStatusColor(user.status)}">
                                        ${escapeHtml(user.status ? user.status.charAt(0).toUpperCase() + user.status.slice(1) : 'N/A')}
                                    </span>
                                </p>
                            </div>
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Created At</label>
                                <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${createdDate}</p>
                            </div>
                            <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Updated At</label>
                                <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${updatedDate}</p>
                            </div>
                        </div>
                        
                        <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-6">
                            <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Company/Shop Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Company Name</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.company_name) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Company Category</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.company_category) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Business Type</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.business_type) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700 md:col-span-2">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Company Description</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.company_description) || 'N/A'}</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-6">
                            <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Contact Information</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Phone</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.phone) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Website</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${user.website ? `<a href="${escapeHtml(user.website)}" target="_blank" class="text-blue-600 hover:underline">${escapeHtml(user.website)}</a>` : 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700 md:col-span-2">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Address</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.address) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">City</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.city) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">State</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.state) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Country</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.country) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Postal Code</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.postal_code) || 'N/A'}</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-6">
                            <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Social Media & Marketing</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Social Media Handles</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(socialHandles)}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Preferred Social Platforms</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(preferredPlatforms)}</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mt-6 border-t border-gray-200 dark:border-gray-700 pt-6">
                            <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Business Details</h4>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Business Registration Number</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(user.business_registration_number) || 'N/A'}</p>
                                </div>
                                <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                                    <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Business Established Date</label>
                                    <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${businessDate}</p>
                                </div>
                            </div>
                        </div>
                        
                        ${subscriptionHtml}
                    </div>
                `;
            })
            .catch(error => {
                dataContainer.innerHTML = `
                    <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                        <p class="text-sm text-red-800 dark:text-red-200">Error loading app user data: ${error.message}</p>
                    </div>
                `;
            });
    }
    
    window.closeViewAppUserModal = function() {
        const modal = document.getElementById('viewAppUserModal');
        modal.classList.add('hidden');
    }
    
    function escapeHtml(text) {
        if (!text) return '';
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.toString().replace(/[&<>"']/g, m => map[m]);
    }
    
    function getStatusColor(status) {
        if (!status) return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
        const statusLower = status.toLowerCase();
        if (statusLower === 'active') {
            return 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200';
        } else if (statusLower === 'inactive') {
            return 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200';
        } else if (statusLower === 'suspended') {
            return 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200';
        }
        return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
    }
    
    function getSubscriptionStatusColor(status) {
        if (!status) return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
        const statusLower = status.toLowerCase();
        if (statusLower === 'active') {
            return 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200';
        } else if (statusLower === 'expired') {
            return 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200';
        } else if (statusLower === 'cancelled') {
            return 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200';
        }
        return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
    }
</script>
<?php /**PATH /var/www/html/social-platform/resources/views/admin/appusers/partials/view-modal.blade.php ENDPATH**/ ?>