

<?php $__env->startSection('title', 'App Users'); ?>

<?php $__env->startSection('content'); ?>

<div class="container">
    <div class="p-4 mx-auto max-w-(--breakpoint-2xl) md:p-6">
        <div class="grid grid-cols-12 gap-4 md:gap-6">
            <div class="col-span-12 xl:col-span-12">
                <div class="overflow-hidden rounded-2xl border border-gray-200 bg-white px-4 pb-3 pt-4 dark:border-gray-800 dark:bg-white/[0.03] sm:px-6">
                    <div class="flex flex-col gap-2 mb-4 sm:flex-row sm:items-center sm:justify-between">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">
                                App Users
                            </h3>
                        </div>
                    </div>

                    <div class="w-full overflow-x-visible">
                    <table id="example" class="display w-full break-words">
        <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Plan</th>
                <th>Subscription Status</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Status</th>
                <th>Created</th>
                <th data-orderable="false">Actions</th>
            </tr>
        </thead>
        <tbody>
        </tbody>
        
    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    

    <?php echo $__env->make('admin.appusers.partials.view-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('admin.appusers.partials.edit-modal', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Modal JS (basic, you can enhance with Alpine.js or Vue) -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof DataTable !== 'undefined') {
                
                new DataTable('#example', {
    processing: true,
    serverSide: true,
    ajax: {
        url: '<?php echo e(route('appusers.data')); ?>',
        type: 'GET'
    },
    columns: [
        { data: 'name', name: 'name' },
        { data: 'email', name: 'email' },
        { data: 'subscription_plan', name: 'subscription_plan' },
        { data: 'subscription_status', name: 'subscription_status' },
        { data: 'start_date', name: 'start_date' },
        { data: 'end_date', name: 'end_date' },
        { data: 'status', name: 'status' },
        { data: 'created', name: 'created_at' },
        { data: 'actions', name: 'actions', orderable: false, searchable: false }
    ],
    responsive: true,
    columnDefs: [
        { orderable: false, targets: -1 }
    ],
    layout: {
       
        topEnd: {
            search: {
                placeholder: 'Search app users...'
            }
        },
        bottomStart: null,
        bottomEnd: {
            paging: {
                first: false,
                last: false,
                previous: false,
                next: false
            }
        }
    },
    language: {
        search: "",
        searchPlaceholder: "Search app users...",
        lengthMenu: "Show _MENU_ entries",
        info: "Showing _START_ to _END_ of _TOTAL_ entries",
        paginate: {
            first: "First",
            last: "Last", 
            next: "Next",
            previous: "Previous"
        }
    }
});
            }

        });
    </script>

</div>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/social-platform/resources/views/admin/appusers/index.blade.php ENDPATH**/ ?>