<!-- Edit App User Modal -->
<div id="editAppUserModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closeEditAppUserModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-5xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03] overflow-y-auto max-h-[90vh]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Edit App User</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700" onclick="closeEditAppUserModal()">✕</button>
        </div>
        <form id="editAppUserForm" action="#" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="space-y-6">
                <!-- Basic Information -->
                <div>
                    <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Basic Information</h4>
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Name *</label>
                            <input type="text" name="name" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" required />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Email *</label>
                            <input type="email" name="email" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" required />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Password</label>
                            <input type="password" name="password" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                            <p class="mt-1 text-xs text-gray-500">Leave blank to keep current password</p>
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Confirm Password</label>
                            <input type="password" name="password_confirmation" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Timezone</label>
                            <input type="text" name="timezone" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Status</label>
                            <select name="status" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white">
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                                <option value="suspended">Suspended</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <!-- Company/Shop Information -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Company/Shop Information</h4>
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Company Name</label>
                            <input type="text" name="company_name" id="company_name" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Company Category</label>
                            <input type="text" name="company_category" id="company_category" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Business Type</label>
                            <input type="text" name="business_type" id="business_type" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div class="sm:col-span-2">
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Company Description</label>
                            <textarea name="company_description" id="company_description" rows="3" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white"></textarea>
                        </div>
                    </div>
                </div>
                
                <!-- Contact Information -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Contact Information</h4>
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Phone</label>
                            <input type="text" name="phone" id="phone" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Website</label>
                            <input type="url" name="website" id="website" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div class="sm:col-span-2">
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Address</label>
                            <textarea name="address" id="address" rows="2" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white"></textarea>
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">City</label>
                            <input type="text" name="city" id="city" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">State</label>
                            <input type="text" name="state" id="state" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Country</label>
                            <input type="text" name="country" id="country" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Postal Code</label>
                            <input type="text" name="postal_code" id="postal_code" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                    </div>
                </div>
                
                <!-- Social Media & Marketing -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Social Media & Marketing</h4>
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Social Media Handles</label>
                            <textarea name="social_media_handles" id="social_media_handles" rows="4" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" placeholder="facebook: @handle, instagram: @handle, twitter: @handle"></textarea>
                            <p class="mt-1 text-xs text-gray-500">Enter as "platform: handle" pairs, comma-separated (e.g., facebook: @fashionforward, instagram: @fashionforward_nyc)</p>
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Preferred Social Platforms</label>
                            <input type="text" name="preferred_social_platforms" id="preferred_social_platforms" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" placeholder="facebook, instagram" />
                            <p class="mt-1 text-xs text-gray-500">Enter comma-separated values (e.g., facebook, instagram)</p>
                        </div>
                    </div>
                </div>
                
                <!-- Business Details -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Business Details</h4>
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Business Registration Number</label>
                            <input type="text" name="business_registration_number" id="business_registration_number" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Business Established Date</label>
                            <input type="date" name="business_established_date" id="business_established_date" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                    </div>
                </div>
                
                <!-- Subscription Details -->
                <div class="border-t border-gray-200 dark:border-gray-700 pt-6">
                    <h4 class="text-md font-semibold text-gray-800 dark:text-white/90 mb-4">Subscription Details</h4>
                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                        <input type="hidden" name="subscription_id" id="subscription_id" />
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Plan</label>
                            <select name="plan_id" id="plan_id" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white">
                                <option value="">Select Plan</option>
                                <?php $__currentLoopData = \App\Models\SubscriptionPlan::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>"><?php echo e($plan->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Subscription Status</label>
                            <select name="subscription_status" id="subscription_status" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white">
                                <option value="active">Active</option>
                                <option value="expired">Expired</option>
                                <option value="cancelled">Cancelled</option>
                            </select>
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Start Date</label>
                            <input type="date" name="start_date" id="start_date" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">End Date</label>
                            <input type="date" name="end_date" id="end_date" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Payment Method</label>
                            <select name="payment_method" id="payment_method" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white">
                                <option value="manual">Manual</option>
                                <option value="stripe">Stripe</option>
                                <option value="paypal">PayPal</option>
                            </select>
                        </div>
                        <div>
                            <label class="mb-1 block text-sm font-medium text-gray-700 dark:text-gray-300">Transaction ID</label>
                            <input type="text" name="transaction_id" id="transaction_id" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300 dark:bg-gray-800 dark:border-gray-700 dark:text-white" />
                        </div>
                    </div>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end gap-3">
                <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-300" onclick="closeEditAppUserModal()">Cancel</button>
                <button type="submit" class="inline-flex items-center rounded-lg bg-gray-900 px-4 py-2.5 text-sm font-medium text-white hover:bg-black dark:bg-white dark:text-gray-900">Save</button>
            </div>
        </form>
    </div>
    
    <script>
        let originalStartDate = null;
        let originalEndDate = null;
        let isManualDateChange = false;

        // Function to calculate end date based on plan duration
        function calculateEndDate(startDate, duration) {
            const start = new Date(startDate);
            let end = new Date(start);
            
            if (duration === 'monthly') {
                end.setMonth(end.getMonth() + 1);
            } else if (duration === 'yearly') {
                end.setFullYear(end.getFullYear() + 1);
            }
            
            return end.toISOString().split('T')[0];
        }

        // Function to auto-calculate dates when plan is selected
        function handlePlanChange(planId) {
            if (!planId) return;
            
            const startDateInput = document.getElementById('start_date');
            const endDateInput = document.getElementById('end_date');
            
            // If start date is empty, set it to today
            if (!startDateInput.value) {
                const today = new Date().toISOString().split('T')[0];
                startDateInput.value = today;
                originalStartDate = today;
            }
            
            // Fetch plan details to get duration
            fetch(`/admin/appusers/plan/${planId}`)
                .then(response => response.json())
                .then(plan => {
                    if (plan.duration && startDateInput.value) {
                        // Only auto-calculate end date if it wasn't manually set
                        if (!isManualDateChange || !endDateInput.value) {
                            const calculatedEndDate = calculateEndDate(startDateInput.value, plan.duration);
                            endDateInput.value = calculatedEndDate;
                            originalEndDate = calculatedEndDate;
                        }
                    }
                })
                .catch(error => {
                    console.error('Error fetching plan details:', error);
                });
        }

        window.openEditAppUserModal = function(userId) {
            const modal = document.getElementById('editAppUserModal');
            const form = document.getElementById('editAppUserForm');
            if (!modal || !form) return;

            // Set action to update route
            form.action = `/admin/appusers/${userId}`;

            // Reset fields
            form.reset();
            originalStartDate = null;
            originalEndDate = null;
            isManualDateChange = false;

            // Fetch user data
            fetch(`/admin/appusers/${userId}`)
                .then(r => r.json())
                .then(data => {
                    const user = data.user;
                    const subscription = data.subscription;
                    
                    // Populate basic fields
                    form.querySelector('input[name="name"]').value = user.name || '';
                    form.querySelector('input[name="email"]').value = user.email || '';
                    const tz = form.querySelector('input[name="timezone"]');
                    if (tz) tz.value = user.timezone || '';
                    const status = form.querySelector('select[name="status"]');
                    if (status) status.value = (user.status || 'active');
                    
                    // Populate company fields
                    const companyName = form.querySelector('#company_name');
                    if (companyName) companyName.value = user.company_name || '';
                    const companyCategory = form.querySelector('#company_category');
                    if (companyCategory) companyCategory.value = user.company_category || '';
                    const companyDescription = form.querySelector('#company_description');
                    if (companyDescription) companyDescription.value = user.company_description || '';
                    const businessType = form.querySelector('#business_type');
                    if (businessType) businessType.value = user.business_type || '';
                    
                    // Populate contact fields
                    const phone = form.querySelector('#phone');
                    if (phone) phone.value = user.phone || '';
                    const website = form.querySelector('#website');
                    if (website) website.value = user.website || '';
                    const address = form.querySelector('#address');
                    if (address) address.value = user.address || '';
                    const city = form.querySelector('#city');
                    if (city) city.value = user.city || '';
                    const state = form.querySelector('#state');
                    if (state) state.value = user.state || '';
                    const country = form.querySelector('#country');
                    if (country) country.value = user.country || '';
                    const postalCode = form.querySelector('#postal_code');
                    if (postalCode) postalCode.value = user.postal_code || '';
                    
                    // Populate social media handles (convert JSON object to "platform: handle" format)
                    const socialHandles = form.querySelector('#social_media_handles');
                    if (socialHandles) {
                        if (user.social_media_handles) {
                            try {
                                const parsed = typeof user.social_media_handles === 'string' ? JSON.parse(user.social_media_handles) : user.social_media_handles;
                                if (typeof parsed === 'object' && parsed !== null && !Array.isArray(parsed)) {
                                    // Convert object to "platform: handle" format
                                    const entries = Object.entries(parsed)
                                        .filter(([key, value]) => value)
                                        .map(([key, value]) => `${key}: ${value}`);
                                    socialHandles.value = entries.join(', ');
                                } else if (Array.isArray(parsed)) {
                                    // Fallback for array format
                                    socialHandles.value = parsed.filter(item => item).join(', ');
                                } else {
                                    socialHandles.value = '';
                                }
                            } catch(e) {
                                socialHandles.value = user.social_media_handles;
                            }
                        }
                    }
                    const preferredPlatforms = form.querySelector('#preferred_social_platforms');
                    if (preferredPlatforms) {
                        if (user.preferred_social_platforms) {
                            try {
                                const parsed = typeof user.preferred_social_platforms === 'string' ? JSON.parse(user.preferred_social_platforms) : user.preferred_social_platforms;
                                preferredPlatforms.value = Array.isArray(parsed) ? parsed.filter(item => item).join(', ') : '';
                            } catch(e) {
                                preferredPlatforms.value = user.preferred_social_platforms;
                            }
                        }
                    }
                    
                    // Populate business fields
                    const businessReg = form.querySelector('#business_registration_number');
                    if (businessReg) businessReg.value = user.business_registration_number || '';
                    const businessDate = form.querySelector('#business_established_date');
                    if (businessDate && user.business_established_date) {
                        const date = new Date(user.business_established_date);
                        businessDate.value = date.toISOString().split('T')[0];
                    }
                    
                    // Populate subscription fields
                    if (subscription) {
                        const subId = form.querySelector('#subscription_id');
                        if (subId) subId.value = subscription.id || '';
                        
                        const planId = form.querySelector('#plan_id');
                        if (planId && subscription.plan_id) {
                            planId.value = subscription.plan_id;
                        }
                        
                        const subStatus = form.querySelector('#subscription_status');
                        if (subStatus) subStatus.value = subscription.status || 'active';
                        
                        const startDate = form.querySelector('#start_date');
                        if (startDate && subscription.start_date) {
                            const date = new Date(subscription.start_date);
                            startDate.value = date.toISOString().split('T')[0];
                            originalStartDate = startDate.value;
                        }
                        
                        const endDate = form.querySelector('#end_date');
                        if (endDate && subscription.end_date) {
                            const date = new Date(subscription.end_date);
                            endDate.value = date.toISOString().split('T')[0];
                            originalEndDate = endDate.value;
                        }
                        
                        const paymentMethod = form.querySelector('#payment_method');
                        if (paymentMethod) paymentMethod.value = subscription.payment_method || 'manual';
                        
                        const transactionId = form.querySelector('#transaction_id');
                        if (transactionId) transactionId.value = subscription.transaction_id || '';
                    }
                })
                .catch(error => {
                    console.error('Error loading app user data:', error);
                });

            modal.classList.remove('hidden');
        }

        window.closeEditAppUserModal = function() {
            const modal = document.getElementById('editAppUserModal');
            if (modal) modal.classList.add('hidden');
        }

        // Set up event listeners (using event delegation on the form)
        document.addEventListener('DOMContentLoaded', function() {
            const form = document.getElementById('editAppUserForm');
            if (form) {
                // Use event delegation on the form
                form.addEventListener('change', function(e) {
                    if (e.target.id === 'plan_id' && e.target.value) {
                        handlePlanChange(e.target.value);
                    } else if (e.target.id === 'start_date') {
                        isManualDateChange = true;
                        const planSelect = document.getElementById('plan_id');
                        if (planSelect && planSelect.value && e.target.value) {
                            // Recalculate end date when start date changes
                            handlePlanChange(planSelect.value);
                        }
                    } else if (e.target.id === 'end_date') {
                        isManualDateChange = true;
                    }
                });
                
                // Handle form submission - convert user-friendly format to JSON
                form.addEventListener('submit', function(e) {
                    const socialHandles = form.querySelector('#social_media_handles');
                    if (socialHandles && socialHandles.value) {
                        // Convert "platform: handle" format to JSON object
                        const pairs = socialHandles.value.split(',').map(item => item.trim()).filter(item => item);
                        const obj = {};
                        pairs.forEach(pair => {
                            const colonIndex = pair.indexOf(':');
                            if (colonIndex > 0) {
                                const platform = pair.substring(0, colonIndex).trim();
                                const handle = pair.substring(colonIndex + 1).trim();
                                if (platform && handle) {
                                    obj[platform.toLowerCase()] = handle;
                                }
                            }
                        });
                        socialHandles.value = Object.keys(obj).length > 0 ? JSON.stringify(obj) : '';
                    } else if (socialHandles) {
                        socialHandles.value = '';
                    }
                    
                    const preferredPlatforms = form.querySelector('#preferred_social_platforms');
                    if (preferredPlatforms && preferredPlatforms.value) {
                        // Convert comma-separated string to JSON array
                        const values = preferredPlatforms.value.split(',').map(item => item.trim()).filter(item => item);
                        preferredPlatforms.value = JSON.stringify(values);
                    } else if (preferredPlatforms) {
                        preferredPlatforms.value = '';
                    }
                });
            }
        });
    </script>
</div>
<?php /**PATH /var/www/html/social-platform/resources/views/admin/appusers/partials/edit-modal.blade.php ENDPATH**/ ?>