<div class="flex items-center gap-1 whitespace-nowrap">
    <button onclick="openViewPlanModal(<?php echo e($plan->id); ?>)" title="View" aria-label="View plan" class="inline-flex items-center p-2 text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white">
        <i class="fa-solid fa-eye"></i>
    </button>
    <button onclick="openPlanModal('edit', <?php echo e($plan->id); ?>)" title="Edit" aria-label="Edit plan" class="inline-flex items-center p-2 text-gray-600 hover:text-gray-900 dark:text-gray-300 dark:hover:text-white">
        <i class="fa-solid fa-pen"></i>
    </button>
    <form action="<?php echo e(route('plans.destroy', $plan->id)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this plan?');">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
        <button type="submit" title="Delete" aria-label="Delete plan" class="inline-flex items-center p-2 text-red-600 hover:text-red-700 dark:text-red-400 dark:hover:text-red-300">
            <i class="fa-solid fa-trash"></i>
        </button>
    </form>
</div>


<?php /**PATH /var/www/html/social-platform/resources/views/admin/plans/partials/actions.blade.php ENDPATH**/ ?>