<!-- View Plan Modal -->
<div id="viewPlanModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closeViewPlanModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-3xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Plan Details</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300" onclick="closeViewPlanModal()">
                <i class="fa-solid fa-times"></i>
            </button>
        </div>
        <div class="overflow-auto max-h-[70vh]">
            <div id="planDataContainer" class="space-y-4">
                <div class="text-center py-8">
                    <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900 dark:border-white"></div>
                    <p class="mt-2 text-gray-600 dark:text-gray-400">Loading plan data...</p>
                </div>
            </div>
        </div>
        <div class="mt-6 flex items-center justify-end gap-3">
            <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-300" onclick="closeViewPlanModal()">Close</button>
        </div>
    </div>
</div>

<script>
    window.openViewPlanModal = function(planId) {
        const modal = document.getElementById('viewPlanModal');
        const dataContainer = document.getElementById('planDataContainer');
        
        // Show modal with loading state
        dataContainer.innerHTML = `
            <div class="text-center py-8">
                <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900 dark:border-white"></div>
                <p class="mt-2 text-gray-600 dark:text-gray-400">Loading plan data...</p>
            </div>
        `;
        modal.classList.remove('hidden');
        
        // Fetch plan data
        fetch(`/admin/plans/${planId}`)
            .then(response => response.json())
            .then(data => {
                const plan = data.data || data;
                // Format and display as HTML
                const createdDate = plan.created_at ? new Date(plan.created_at).toLocaleString() : 'N/A';
                const updatedDate = plan.updated_at ? new Date(plan.updated_at).toLocaleString() : 'N/A';
                const features = (plan.features || '').split('\n').filter(Boolean);
                const featuresHtml = features.length > 0 
                    ? features.map(f => `<li class="text-sm text-gray-700 dark:text-gray-300">${escapeHtml(f)}</li>`).join('')
                    : '<li class="text-sm text-gray-500 dark:text-gray-400">No features specified</li>';
                
                dataContainer.innerHTML = `
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">ID</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${plan.id || 'N/A'}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Name</label>
                            <p class="mt-1">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${getPlanNameColor(plan.name)}">
                                    ${escapeHtml(plan.name ? plan.name.charAt(0).toUpperCase() + plan.name.slice(1) : 'N/A')}
                                </span>
                            </p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Price</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">₹${Number(plan.price || 0).toFixed(2)}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Duration</label>
                            <p class="mt-1">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                    ${escapeHtml(plan.duration ? plan.duration.charAt(0).toUpperCase() + plan.duration.slice(1) : 'N/A')}
                                </span>
                            </p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Max Posts / Month</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${plan.max_posts_per_month || 0}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Max Social Accounts</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${plan.max_social_accounts || 0}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">AI Credits</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${plan.ai_credits || 0}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Status</label>
                            <p class="mt-1">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${getStatusColor(plan.status)}">
                                    ${escapeHtml(plan.status ? plan.status.charAt(0).toUpperCase() + plan.status.slice(1) : 'N/A')}
                                </span>
                            </p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700 md:col-span-2">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Features</label>
                            <ul class="mt-2 space-y-1">
                                ${featuresHtml}
                            </ul>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Created At</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${createdDate}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Updated At</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${updatedDate}</p>
                        </div>
                    </div>
                `;
            })
            .catch(error => {
                dataContainer.innerHTML = `
                    <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                        <p class="text-sm text-red-800 dark:text-red-200">Error loading plan data: ${error.message}</p>
                    </div>
                `;
            });
    }
    
    window.closeViewPlanModal = function() {
        const modal = document.getElementById('viewPlanModal');
        modal.classList.add('hidden');
    }
    
    function escapeHtml(text) {
        if (!text) return '';
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.toString().replace(/[&<>"']/g, m => map[m]);
    }
    
    function getStatusColor(status) {
        if (!status) return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
        const statusLower = status.toLowerCase();
        if (statusLower === 'active') {
            return 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200';
        } else if (statusLower === 'inactive') {
            return 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200';
        }
        return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
    }
    
    function getPlanNameColor(name) {
        if (!name) return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
        const nameLower = name.toLowerCase();
        if (nameLower === 'free') {
            return 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200';
        } else if (nameLower === 'premium') {
            return 'bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200';
        } else if (nameLower === 'elite') {
            return 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200';
        }
        return 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200';
    }
</script>


<?php /**PATH /var/www/html/social-platform/resources/views/admin/plans/partials/view-modal.blade.php ENDPATH**/ ?>