<!-- Create Plan Modal -->
<div id="createPlanModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closePlanModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-2xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Create Plan</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300" onclick="closePlanModal()">
                <i class="fa-solid fa-times"></i>
            </button>
        </div>
        <form id="createPlanForm" action="<?php echo e(route('plans.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Name</label>
                    <select name="name" class="w-full rounded-lg border border-gray-300 px-3 py-2" required>
                        <option value="free" <?php if(old('name')==='free'): echo 'selected'; endif; ?>>Free</option>
                        <option value="premium" <?php if(old('name')==='premium'): echo 'selected'; endif; ?>>Premium</option>
                        <option value="elite" <?php if(old('name')==='elite'): echo 'selected'; endif; ?>>Elite</option>
                    </select>
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Price</label>
                    <input type="number" step="0.01" name="price" class="w-full rounded-lg border border-gray-300 px-3 py-2" value="<?php echo e(old('price', 0)); ?>" required />
                    <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Duration</label>
                    <select name="duration" class="w-full rounded-lg border border-gray-300 px-3 py-2" required>
                        <option value="monthly" <?php if(old('duration','monthly')==='monthly'): echo 'selected'; endif; ?>>Monthly</option>
                        <option value="yearly" <?php if(old('duration')==='yearly'): echo 'selected'; endif; ?>>Yearly</option>
                    </select>
                    <?php $__errorArgs = ['duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Max Posts / Month</label>
                    <input type="number" name="max_posts_per_month" class="w-full rounded-lg border border-gray-300 px-3 py-2" value="<?php echo e(old('max_posts_per_month', 0)); ?>" required />
                    <?php $__errorArgs = ['max_posts_per_month'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Max Social Accounts</label>
                    <input type="number" name="max_social_accounts" class="w-full rounded-lg border border-gray-300 px-3 py-2" value="<?php echo e(old('max_social_accounts', 1)); ?>" required />
                    <?php $__errorArgs = ['max_social_accounts'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">AI Credits</label>
                    <input type="number" name="ai_credits" class="w-full rounded-lg border border-gray-300 px-3 py-2" value="<?php echo e(old('ai_credits', 0)); ?>" required />
                    <?php $__errorArgs = ['ai_credits'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="sm:col-span-2">
                    <label class="mb-1 block text-sm font-medium text-gray-700">Features (one per line)</label>
                    <textarea name="features" rows="4" class="w-full rounded-lg border border-gray-300 px-3 py-2" placeholder="Feature 1\nFeature 2"><?php echo e(old('features')); ?></textarea>
                    <?php $__errorArgs = ['features'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                        <option value="active" <?php if(old('status','active')==='active'): echo 'selected'; endif; ?>>Active</option>
                        <option value="inactive" <?php if(old('status')==='inactive'): echo 'selected'; endif; ?>>Inactive</option>
                    </select>
                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end gap-3">
                <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50" onclick="closePlanModal()">Cancel</button>
                <button type="submit" class="inline-flex items-center rounded-lg bg-gray-900 px-4 py-2.5 text-sm font-medium text-white hover:bg-black">Create</button>
            </div>
        </form>
    </div>
</div>

<script>
    window.openPlanModal = async function(mode, id = null) {
        if (mode === 'create') {
            document.getElementById('createPlanModal')?.classList.remove('hidden');
            return;
        }
        if (mode === 'view') {
            if (typeof openViewPlanModal === 'function') {
                openViewPlanModal(id);
            }
            return;
        }
        if (mode === 'edit') {
            const res = await fetch(`<?php echo e(url('admin/plans')); ?>/${id}`);
            const json = await res.json();
            window.populatePlanEdit(id, json.data);
            document.getElementById('editPlanModal')?.classList.remove('hidden');
            return;
        }
    }
    window.closePlanModal = function() {
        document.getElementById('createPlanModal')?.classList.add('hidden');
        document.getElementById('editPlanModal')?.classList.add('hidden');
    }
</script>


<?php /**PATH /var/www/html/social-platform/resources/views/admin/plans/partials/create-modal.blade.php ENDPATH**/ ?>