<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\ReportController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\AppUserController;

Route::get('/', fn() => view('welcome'));

// Admin Authentication Routes
Route::prefix('admin')->group(function () {
    Route::get('/', function () {
        return redirect()->route('admin.login');
    })->name('admin');
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('admin.login');
    Route::post('/login', [AuthController::class, 'login'])->name('admin.login.post');
    Route::post('/logout', [AuthController::class, 'logout'])->name('admin.logout');
});

Route::middleware(['auth', 'role:admin'])->prefix('admin')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('users/data', [UserController::class, 'data'])->name('users.data');
    Route::resource('users', UserController::class);
    Route::get('appusers/data', [AppUserController::class, 'data'])->name('appusers.data');
    Route::get('appusers/plan/{planId}', [AppUserController::class, 'getPlanDetails'])->name('appusers.plan.details');
    Route::resource('appusers', AppUserController::class)->parameters(['appusers' => 'appuser']);
    Route::get('categories/data', [CategoryController::class, 'data'])->name('categories.data');
    Route::resource('categories', CategoryController::class);
    Route::get('plans/data', [PlanController::class, 'data'])->name('plans.data');
    Route::resource('plans', PlanController::class);
    // Subscriptions nested under users
    Route::get('users/{user}/subscription', [SubscriptionController::class, 'show'])->name('users.subscription.show');
    Route::post('users/{user}/subscription', [SubscriptionController::class, 'store'])->name('users.subscription.store');
    Route::put('users/{user}/subscription/{subscription}', [SubscriptionController::class, 'update'])->name('users.subscription.update');
    Route::get('reports', [ReportController::class, 'index'])->name('admin.reports');
});
