<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>@yield('title', 'Admin Dashboard') - Auto-Pilot</title>
    
    <!-- Laravel Vite Assets -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    
    <!-- Alpine.js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body
    x-data="{ 
        page: 'plans', 
        'loaded': true, 
        'darkMode': false, 
        'stickyMenu': false, 
        'sidebarToggle': false, 
        'scrollTop': false 
    }"
    x-init="
        darkMode = JSON.parse(localStorage.getItem('darkMode')) || false;
        $watch('darkMode', value => localStorage.setItem('darkMode', JSON.stringify(value)))"
    :class="{'dark bg-gray-900': darkMode === true}"
>
    <!-- ===== Preloader Start ===== -->
    <div x-show="!loaded" class="fixed inset-0 z-9999 flex items-center justify-center bg-white dark:bg-black">
        <div class="h-16 w-16 animate-spin rounded-full border-4 border-solid border-primary border-t-transparent"></div>
    </div>
    <!-- ===== Preloader End ===== -->

    <!-- ===== Page Wrapper Start ===== -->
    <div class="flex h-screen overflow-hidden">
        <!-- ===== Sidebar Start ===== -->
        <aside
            :class="sidebarToggle ? 'translate-x-0 lg:w-[90px]' : '-translate-x-full'"
            class="fixed left-0 top-0 z-50 flex h-screen w-72 flex-col overflow-y-hidden border-r border-gray-200 bg-white px-5 dark:border-gray-800 dark:bg-gray-900 lg:static lg:translate-x-0"
        >
            <!-- SIDEBAR HEADER -->
            <div
                :class="sidebarToggle ? 'justify-center' : 'justify-between'"
                class="flex items-center gap-2 pt-8 sidebar-header pb-7"
            >
                <a href="{{ route('admin.dashboard') }}">
                    <span class="logo" :class="sidebarToggle ? 'hidden' : ''">
                        <img class="dark:hidden" src="{{ asset('images/logo/logo.svg') }}" alt="Logo" />
                        <img class="hidden dark:block" src="{{ asset('images/logo/logo-dark.svg') }}" alt="Logo" />
                    </span>
                    <img
                        class="logo-icon"
                        :class="sidebarToggle ? 'lg:block' : 'hidden'"
                        src="{{ asset('images/logo/logo-icon.svg') }}"
                        alt="Logo"
                    />
                </a>
            </div>
            <!-- SIDEBAR HEADER -->

            <div class="flex flex-col overflow-y-auto duration-300 ease-linear no-scrollbar">
                <!-- Sidebar Menu -->
                <nav x-data="{selected: 'Dashboard'}">
                    <!-- Menu Group -->
                    <div>
                        <h3 class="mb-4 text-xs uppercase leading-[20px] text-gray-400">
                            <span class="menu-group-title" :class="sidebarToggle ? 'lg:hidden' : ''">
                                MENU
                            </span>
                            <svg
                                :class="sidebarToggle ? 'lg:block hidden' : 'hidden'"
                                class="mx-auto fill-current menu-group-icon"
                                width="24"
                                height="24"
                                viewBox="0 0 24 24"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <path
                                    fill-rule="evenodd"
                                    clip-rule="evenodd"
                                    d="M5.99915 10.2451C6.96564 10.2451 7.74915 11.0286 7.74915 11.9951V12.0051C7.74915 12.9716 6.96564 13.7551 5.99915 13.7551C5.03265 13.7551 4.24915 12.9716 4.24915 12.0051V11.9951C4.24915 11.0286 5.03265 10.2451 5.99915 10.2451ZM17.9991 10.2451C18.9656 10.2451 19.7491 11.0286 19.7491 11.9951V12.0051C19.7491 12.9716 18.9656 13.7551 17.9991 13.7551C17.0326 13.7551 16.2491 12.9716 16.2491 12.0051V11.9951C16.2491 11.0286 17.0326 10.2451 17.9991 10.2451ZM13.7491 11.9951C13.7491 11.0286 12.9656 10.2451 11.9991 10.2451C11.0326 10.2451 10.2491 11.0286 10.2491 11.9951V12.0051C10.2491 12.9716 11.0326 13.7551 11.9991 13.7551C12.9656 13.7551 13.7491 12.9716 13.7491 12.0051V11.9951Z"
                                    fill=""
                                />
                            </svg>
                        </h3>

                        <ul class="flex flex-col gap-4 mb-6">
                            <!-- Menu Item Dashboard -->
                            <li>
                                <a
                                    href="{{ route('admin.dashboard') }}"
                                    class="menu-item group"
                                    :class="page === 'dashboard' ? 'menu-item-active' : 'menu-item-inactive'"
                                >
                                    <svg
                                        :class="page === 'dashboard' ? 'menu-item-icon-active' : 'menu-item-icon-inactive'"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 24 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M5.5 3.25C4.25736 3.25 3.25 4.25736 3.25 5.5V8.99998C3.25 10.2426 4.25736 11.25 5.5 11.25H9C10.2426 11.25 11.25 10.2426 11.25 8.99998V5.5C11.25 4.25736 10.2426 3.25 9 3.25H5.5ZM4.75 5.5C4.75 5.08579 5.08579 4.75 5.5 4.75H9C9.41421 4.75 9.75 5.08579 9.75 5.5V8.99998C9.75 9.41419 9.41421 9.74998 9 9.74998H5.5C5.08579 9.74998 4.75 9.41419 4.75 8.99998V5.5ZM5.5 12.75C4.25736 12.75 3.25 13.7574 3.25 15V18.5C3.25 19.7426 4.25736 20.75 5.5 20.75H9C10.2426 20.75 11.25 19.7427 11.25 18.5V15C11.25 13.7574 10.2426 12.75 9 12.75H5.5ZM4.75 15C4.75 14.5858 5.08579 14.25 5.5 14.25H9C9.41421 14.25 9.75 14.5858 9.75 15V18.5C9.75 18.9142 9.41421 19.25 9 19.25H5.5C5.08579 19.25 4.75 18.9142 4.75 18.5V15ZM12.75 5.5C12.75 4.25736 13.7574 3.25 15 3.25H18.5C19.7426 3.25 20.75 4.25736 20.75 5.5V8.99998C20.75 10.2426 19.7426 11.25 18.5 11.25H15C13.7574 11.25 12.75 10.2426 12.75 8.99998V5.5ZM15 4.75C14.5858 4.75 14.25 5.08579 14.25 5.5V8.99998C14.25 9.41419 14.5858 9.74998 15 9.74998H18.5C18.9142 9.74998 19.25 9.41419 19.25 8.99998V5.5C19.25 5.08579 18.9142 4.75 18.5 4.75H15ZM15 12.75C13.7574 12.75 12.75 13.7574 12.75 15V18.5C12.75 19.7426 13.7574 20.75 15 20.75H18.5C19.7426 20.75 20.75 19.7427 20.75 18.5V15C20.75 13.7574 19.7426 12.75 18.5 12.75H15ZM14.25 15C14.25 14.5858 14.5858 14.25 15 14.25H18.5C18.9142 14.25 19.25 14.5858 19.25 15V18.5C19.25 18.9142 18.9142 19.25 18.5 19.25H15C14.5858 19.25 14.25 18.9142 14.25 18.5V15Z"
                                            fill=""
                                        />
                                    </svg>
                                    <span class="menu-item-text" :class="sidebarToggle ? 'lg:hidden' : ''">
                                        Dashboard
                                    </span>
                                </a>
                            </li>
                            <!-- Menu Item Dashboard -->

                            <!-- Menu Item Users -->
                            <li>
                                <a
                                    href="{{ route('users.index') }}"
                                    class="menu-item group"
                                    :class="page === 'users' ? 'menu-item-active' : 'menu-item-inactive'"
                                >
                                    <svg
                                        :class="page === 'users' ? 'menu-item-icon-active' : 'menu-item-icon-inactive'"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 24 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M12 3.5C7.30558 3.5 3.5 7.30558 3.5 12C3.5 14.1526 4.3002 16.1184 5.61936 17.616C6.17279 15.3096 8.24852 13.5955 10.7246 13.5955H13.2746C15.7509 13.5955 17.8268 15.31 18.38 17.6167C19.6996 16.119 20.5 14.153 20.5 12C20.5 7.30558 16.6944 3.5 12 3.5ZM17.0246 18.8566V18.8455C17.0246 16.7744 15.3457 15.0955 13.2746 15.0955H10.7246C8.65354 15.0955 6.97461 16.7744 6.97461 18.8455V18.856C8.38223 19.8895 10.1198 20.5 12 20.5C13.8798 20.5 15.6171 19.8898 17.0246 18.8566ZM2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12ZM11.9991 7.25C10.8847 7.25 9.98126 8.15342 9.98126 9.26784C9.98126 10.3823 10.8847 11.2857 11.9991 11.2857C13.1135 11.2857 14.0169 10.3823 14.0169 9.26784C14.0169 8.15342 13.1135 7.25 11.9991 7.25ZM8.48126 9.26784C8.48126 7.32499 10.0563 5.75 11.9991 5.75C13.9419 5.75 15.5169 7.32499 15.5169 9.26784C15.5169 11.2107 13.9419 12.7857 11.9991 12.7857C10.0563 12.7857 8.48126 11.2107 8.48126 9.26784Z"
                                            fill=""
                                        />
                                    </svg>
                                    <span class="menu-item-text" :class="sidebarToggle ? 'lg:hidden' : ''">
                                        Users
                                    </span>
                                </a>
                            </li>
                            <!-- Menu Item Users -->

                            <!-- Menu Item Plans -->
                            <li>
                                <a
                                    href="{{ route('plans.index') }}"
                                    class="menu-item group"
                                    :class="page === 'plans' ? 'menu-item-active' : 'menu-item-inactive'"
                                >
                                    <svg
                                        :class="page === 'plans' ? 'menu-item-icon-active' : 'menu-item-icon-inactive'"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 24 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M3.25 5.5C3.25 4.25736 4.25736 3.25 5.5 3.25H18.5C19.7426 3.25 20.75 4.25736 20.75 5.5V18.5C20.75 19.7426 19.7426 20.75 18.5 20.75H5.5C4.25736 20.75 3.25 19.7426 3.25 18.5V5.5ZM5.5 4.75C5.08579 4.75 4.75 5.08579 4.75 5.5V8.58325L19.25 8.58325V5.5C19.25 5.08579 18.9142 4.75 18.5 4.75H5.5ZM19.25 10.0833H15.416V13.9165H19.25V10.0833ZM13.916 10.0833L10.083 10.0833V13.9165L13.916 13.9165V10.0833ZM8.58301 10.0833H4.75V13.9165H8.58301V10.0833ZM4.75 18.5V15.4165H8.58301V19.25H5.5C5.08579 19.25 4.75 18.9142 4.75 18.5ZM10.083 19.25V15.4165L13.916 15.4165V19.25H10.083ZM15.416 19.25V15.4165H19.25V18.5C19.25 18.9142 18.9142 19.25 18.5 19.25H15.416Z"
                                            fill=""
                                        />
                                    </svg>
                                    <span class="menu-item-text" :class="sidebarToggle ? 'lg:hidden' : ''">
                                        Subscription Plans
                                    </span>
                                </a>
                            </li>
                            <!-- Menu Item Plans -->

                            <!-- Menu Item Reports -->
                            <li>
                                <a
                                    href="{{ route('admin.reports') }}"
                                    class="menu-item group"
                                    :class="page === 'reports' ? 'menu-item-active' : 'menu-item-inactive'"
                                >
                                    <svg
                                        :class="page === 'reports' ? 'menu-item-icon-active' : 'menu-item-icon-inactive'"
                                        width="24"
                                        height="24"
                                        viewBox="0 0 24 24"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            fill-rule="evenodd"
                                            clip-rule="evenodd"
                                            d="M12 2C11.5858 2 11.25 2.33579 11.25 2.75V12C11.25 12.4142 11.5858 12.75 12 12.75H21.25C21.6642 12.75 22 12.4142 22 12C22 6.47715 17.5228 2 12 2ZM12.75 11.25V3.53263C13.2645 3.57761 13.7659 3.66843 14.25 3.80098V3.80099C15.6929 4.19606 16.9827 4.96184 18.0104 5.98959C19.0382 7.01734 19.8039 8.30707 20.199 9.75C20.3316 10.2341 20.4224 10.7355 20.4674 11.25H12.75ZM2 12C2 7.25083 5.31065 3.27489 9.75 2.25415V3.80099C6.14748 4.78734 3.5 8.0845 3.5 12C3.5 16.6944 7.30558 20.5 12 20.5C15.9155 20.5 19.2127 17.8525 20.199 14.25H21.7459C20.7251 18.6894 16.7492 22 12 22C6.47715 22 2 17.5229 2 12Z"
                                            fill=""
                                        />
                                    </svg>
                                    <span class="menu-item-text" :class="sidebarToggle ? 'lg:hidden' : ''">
                                        Reports
                                    </span>
                                </a>
                            </li>
                            <!-- Menu Item Reports -->
                        </ul>
                    </div>
                </nav>
                <!-- Sidebar Menu -->

                <!-- Promo Box -->
                <div
                    :class="sidebarToggle ? 'lg:hidden' : ''"
                    class="mx-auto mb-10 w-full max-w-60 rounded-2xl bg-gray-50 px-4 py-5 text-center dark:bg-white/[0.03]"
                >
                    <h3 class="mb-2 font-semibold text-gray-900 dark:text-white">
                        #1 Tailwind CSS Dashboard
                    </h3>
                    <p class="mb-4 text-gray-500 text-theme-sm dark:text-gray-400">
                        Leading Tailwind CSS Admin Template with 400+ UI Component and Pages.
                    </p>
                    <a
                        href="https://tailadmin.com/pricing"
                        target="_blank"
                        rel="nofollow"
                        class="flex items-center justify-center p-3 font-medium text-white rounded-lg bg-brand-500 text-theme-sm hover:bg-brand-600"
                    >
                        Purchase Plan
                    </a>
                </div>
                <!-- Promo Box -->
            </div>
        </aside>
        <!-- ===== Sidebar End ===== -->

        <!-- ===== Content Area Start ===== -->
        <div class="relative flex flex-col flex-1 overflow-x-hidden overflow-y-auto">
            <!-- Small Device Overlay Start -->
            <div
                x-show="sidebarToggle"
                @click="sidebarToggle = false"
                x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0"
                x-transition:enter-end="opacity-100"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100"
                x-transition:leave-end="opacity-0"
                            class="fixed inset-0 z-40 bg-black/50 lg:hidden"
                style="display: none;"
            ></div>
            <!-- Small Device Overlay End -->

            <!-- ===== Header Start ===== -->
            <header class="sticky top-0 z-40 flex w-full bg-white dark:bg-gray-900">
                <div class="flex flex-grow items-center justify-between px-4 py-4 md:px-6 2xl:px-11">
                    <div class="flex items-center gap-2 sm:gap-4 lg:hidden">
                        <!-- Hamburger Toggle -->
                        <button
                            @click="sidebarToggle = !sidebarToggle"
                            class="z-50 block rounded-sm border border-gray-200 bg-white p-1.5 shadow-sm dark:border-gray-700 dark:bg-gray-800 lg:hidden"
                        >
                            <span class="relative block h-5.5 w-5.5 cursor-pointer">
                                <span class="du-block absolute right-0 h-full w-full">
                                    <span
                                        class="relative left-0 top-0 my-1 block h-0.5 w-0 rounded-sm bg-black delay-[0] duration-200 ease-in-out dark:bg-white"
                                        :class="{'!w-full delay-300': !sidebarToggle}"
                                    ></span>
                                    <span
                                        class="relative left-0 top-0 my-1 block h-0.5 w-0 rounded-sm bg-black delay-150 duration-200 ease-in-out dark:bg-white"
                                        :class="{'!w-full delay-400': !sidebarToggle}"
                                    ></span>
                                    <span
                                        class="relative left-0 top-0 my-1 block h-0.5 w-0 rounded-sm bg-black delay-200 duration-200 ease-in-out dark:bg-white"
                                        :class="{'!w-full delay-500': !sidebarToggle}"
                                    ></span>
                                </span>
                                <span class="absolute right-0 h-full w-full rotate-45">
                                    <span
                                        class="absolute left-2.5 top-0 block h-full w-0.5 rounded-sm bg-black delay-300 duration-200 ease-in-out dark:bg-white"
                                        :class="{'!h-0 delay-[0]': !sidebarToggle}"
                                    ></span>
                                    <span
                                        class="delay-400 absolute left-0 top-2.5 block h-0.5 w-full rounded-sm bg-black duration-200 ease-in-out dark:bg-white"
                                        :class="{'!h-0 delay-200': !sidebarToggle}"
                                    ></span>
                                </span>
                            </span>
                        </button>
                        <!-- Hamburger Toggle -->
                    </div>

                    <div class="flex items-center gap-3 2xsm:gap-7">
                        <!-- Dark Mode Toggle -->
                        <ul class="flex items-center gap-2 2xsm:gap-4">
                            <li>
                                <button
                                    @click="darkMode = !darkMode"
                                    class="relative flex h-8.5 w-8.5 items-center justify-center rounded-full border-[0.5px] border-stroke bg-gray hover:text-primary dark:border-strokedark dark:bg-meta-4 dark:text-white"
                                >
                                    <svg
                                        x-show="!darkMode"
                                        class="fill-current duration-300 ease-in-out"
                                        width="22"
                                        height="22"
                                        viewBox="0 0 22 22"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M16.75 11.5957C16.75 15.4957 13.64 18.6057 9.74 18.6057C5.84 18.6057 2.75 15.4957 2.75 11.5957C2.75 7.6957 5.84 4.5957 9.74 4.5957C10.81 4.5957 11.84 4.8057 12.77 5.2257C13.7 5.6457 14.52 6.2557 15.18 6.9057C15.84 7.5557 16.35 8.3657 16.68 9.2757C17.01 10.1857 17.15 11.1757 16.75 11.5957Z"
                                            fill=""
                                        />
                                    </svg>
                                    <svg
                                        x-show="darkMode"
                                        class="hidden fill-current duration-300 ease-in-out"
                                        width="22"
                                        height="22"
                                        viewBox="0 0 22 22"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M11 7.84424C9.49219 7.84424 8.25 9.08643 8.25 10.5942C8.25 12.102 9.49219 13.3442 11 13.3442C12.5078 13.3442 13.75 12.102 13.75 10.5942C13.75 9.08643 12.5078 7.84424 11 7.84424ZM11 14.8442C8.66379 14.8442 6.75 12.9304 6.75 10.5942C6.75 8.25801 8.66379 6.34424 11 6.34424C13.3362 6.34424 15.25 8.25801 15.25 10.5942C15.25 12.9304 13.3362 14.8442 11 14.8442ZM11 4.84424C10.5858 4.84424 10.25 4.50845 10.25 4.09424V2.09424C10.25 1.68003 10.5858 1.34424 11 1.34424C11.4142 1.34424 11.75 1.68003 11.75 2.09424V4.09424C11.75 4.50845 11.4142 4.84424 11 4.84424ZM11 19.8442C10.5858 19.8442 10.25 19.5085 10.25 19.0942V17.0942C10.25 16.6800 10.5858 16.3442 11 16.3442C11.4142 16.3442 11.75 16.6800 11.75 17.0942V19.0942C11.75 19.5085 11.4142 19.8442 11 19.8442ZM4.96997 6.66424C4.75576 6.45003 4.75576 6.10003 4.96997 5.88582L6.42997 4.42582C6.64418 4.21161 6.99418 4.21161 7.20839 4.42582C7.4226 4.64003 7.4226 4.99003 7.20839 5.20424L5.74839 6.66424C5.53418 6.87845 5.18418 6.87845 4.96997 6.66424ZM16.7916 18.4858C16.5774 18.2716 16.5774 17.9216 16.7916 17.7074L18.2516 16.2474C18.4658 16.0332 18.8158 16.0332 19.03 16.2474C19.2442 16.4616 19.2442 16.8116 19.03 17.0258L17.57 18.4858C17.3558 18.7 17.0058 18.7 16.7916 18.4858ZM2.25 11.5942C2.25 11.18 2.58579 10.8442 3 10.8442H5C5.41421 10.8442 5.75 11.18 5.75 11.5942C5.75 12.0085 5.41421 12.3442 5 12.3442H3C2.58579 12.3442 2.25 12.0085 2.25 11.5942ZM16.25 11.5942C16.25 11.18 16.5858 10.8442 17 10.8442H19C19.4142 10.8442 19.75 11.18 19.75 11.5942C19.75 12.0085 19.4142 12.3442 19 12.3442H17C16.5858 12.3442 16.25 12.0085 16.25 11.5942ZM4.96997 16.5242C5.18418 16.31 5.53418 16.31 5.74839 16.5242L7.20839 17.9842C7.4226 18.1985 7.4226 18.5485 7.20839 18.7627C6.99418 18.9769 6.64418 18.9769 6.42997 18.7627L4.96997 17.3027C4.75576 17.0885 4.75576 16.7385 4.96997 16.5242ZM16.7916 4.70274C17.0058 4.91695 17.3558 4.91695 17.57 4.70274L19.03 3.24274C19.2442 3.02853 19.2442 2.67853 19.03 2.46432C18.8158 2.25011 18.4658 2.25011 18.2516 2.46432L16.7916 3.92432C16.5774 4.13853 16.5774 4.48853 16.7916 4.70274Z"
                                            fill=""
                                        />
                                    </svg>
                                </button>
                            </li>
                        </ul>
                        <!-- Dark Mode Toggle -->

                        <!-- User Area -->
                        <div class="relative">
                            <a class="flex items-center gap-4" href="#">
                                <span class="hidden text-right lg:block">
                                    <span class="block text-sm font-medium text-black dark:text-white">
                                        {{ auth()->user()->name ?? 'Admin' }}
                                    </span>
                                    <span class="block text-xs text-gray-500">Administrator</span>
                                </span>

                                <span class="h-12 w-12 rounded-full">
                                    <img src="{{ asset('images/user/user-01.jpg') }}" alt="User" />
                                </span>

                                <svg
                                    class="hidden fill-current opacity-60 lg:block"
                                    width="12"
                                    height="8"
                                    viewBox="0 0 12 8"
                                    fill="none"
                                    xmlns="http://www.w3.org/2000/svg"
                                >
                                    <path
                                        fill-rule="evenodd"
                                        clip-rule="evenodd"
                                        d="M0.410765 0.910734C0.736202 0.585297 1.26384 0.585297 1.58928 0.910734L6.00002 5.32148L10.4108 0.910734C10.7362 0.585297 11.2638 0.585297 11.5893 0.910734C11.9147 1.23617 11.9147 1.76381 11.5893 2.08924L6.58928 7.08924C6.26384 7.41468 5.7362 7.41468 5.41077 7.08924L0.410765 2.08924C0.0853277 1.76381 0.0853277 1.23617 0.410765 0.910734Z"
                                        fill=""
                                    />
                                </svg>
                            </a>
                        </div>
                        <!-- User Area -->
                    </div>
                </div>
            </header>
            <!-- ===== Header End ===== -->

            <!-- ===== Main Content Start ===== -->
            <main>
                <div class="p-4 mx-auto max-w-screen-2xl md:p-6">
                    @if(session('success'))
                        <div x-data="{ show: true }" x-show="show" x-transition class="mb-4 rounded-lg border border-success bg-success/10 px-4 py-3 text-success">
                            <div class="flex items-center">
                                <svg class="mr-2 h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                {{ session('success') }}
                                <button @click="show = false" class="ml-auto">
                                    <svg class="h-4 w-4" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                                    </svg>
                                </button>
                            </div>
                        </div>
                    @endif
                    
                    @yield('content')
                </div>
            </main>
            <!-- ===== Main Content End ===== -->
        </div>
        <!-- ===== Content Area End ===== -->
    </div>
    <!-- ===== Page Wrapper End ===== -->
</body>
</html>
