<!-- Edit User Modal -->
<div id="editUserModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closeEditUserModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-2xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Edit User</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700" onclick="closeEditUserModal()">✕</button>
        </div>
        <form id="editUserForm" action="#" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Name</label>
                    <input type="text" name="name" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" required />
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" name="email" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" required />
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Password</label>
                    <input type="password" name="password" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" />
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Confirm Password</label>
                    <input type="password" name="password_confirmation" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" />
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Timezone</label>
                    <input type="text" name="timezone" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" />
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                        <option value="suspended">Suspended</option>
                    </select>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end gap-3">
                <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50" onclick="closeEditUserModal()">Cancel</button>
                <button type="submit" class="inline-flex items-center rounded-lg bg-gray-900 px-4 py-2.5 text-sm font-medium text-white hover:bg-black">Save</button>
            </div>
        </form>
    </div>
    
    <script>
        window.openEditUserModal = function(userId) {
            const modal = document.getElementById('editUserModal');
            const form = document.getElementById('editUserForm');
            if (!modal || !form) return;

            // Set action to update route
            form.action = `/admin/users/${userId}`;

            // Reset fields
            form.reset();

            // Fetch user data
            fetch(`/admin/users/${userId}`)
                .then(r => r.json())
                .then(data => {
                    form.querySelector('input[name="name"]').value = data.name || '';
                    form.querySelector('input[name="email"]').value = data.email || '';
                    const tz = form.querySelector('input[name="timezone"]');
                    if (tz) tz.value = data.timezone || '';
                    const status = form.querySelector('select[name="status"]');
                    if (status) status.value = (data.status || 'active');
                })
                .catch(() => {});

            modal.classList.remove('hidden');
        }

        window.closeEditUserModal = function() {
            const modal = document.getElementById('editUserModal');
            if (modal) modal.classList.add('hidden');
        }
    </script>
</div>


