<!-- Edit Plan Modal -->
<div id="editPlanModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closePlanModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-2xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Edit Plan</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300" onclick="closePlanModal()">
                <i class="fa-solid fa-times"></i>
            </button>
        </div>
        <form id="editPlanForm" method="POST">
            @csrf
            @method('PUT')
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Name</label>
                    <select name="name" class="w-full rounded-lg border border-gray-300 px-3 py-2" required>
                        <option value="free">Free</option>
                        <option value="premium">Premium</option>
                        <option value="elite">Elite</option>
                    </select>
                    @error('name')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Price</label>
                    <input type="number" step="0.01" name="price" class="w-full rounded-lg border border-gray-300 px-3 py-2" required />
                    @error('price')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Duration</label>
                    <select name="duration" class="w-full rounded-lg border border-gray-300 px-3 py-2" required>
                        <option value="monthly">Monthly</option>
                        <option value="yearly">Yearly</option>
                    </select>
                    @error('duration')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Max Posts / Month</label>
                    <input type="number" name="max_posts_per_month" class="w-full rounded-lg border border-gray-300 px-3 py-2" required />
                    @error('max_posts_per_month')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Max Social Accounts</label>
                    <input type="number" name="max_social_accounts" class="w-full rounded-lg border border-gray-300 px-3 py-2" required />
                    @error('max_social_accounts')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">AI Credits</label>
                    <input type="number" name="ai_credits" class="w-full rounded-lg border border-gray-300 px-3 py-2" required />
                    @error('ai_credits')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div class="sm:col-span-2">
                    <label class="mb-1 block text-sm font-medium text-gray-700">Features (one per line)</label>
                    <textarea name="features" rows="4" class="w-full rounded-lg border border-gray-300 px-3 py-2"></textarea>
                    @error('features')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" class="w-full rounded-lg border border-gray-300 px-3 py-2">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    @error('status')<p class="mt-1 text-sm text-red-600">{{ $message }}</p>@enderror
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end gap-3">
                <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50" onclick="closePlanModal()">Cancel</button>
                <button type="submit" class="inline-flex items-center rounded-lg bg-gray-900 px-4 py-2.5 text-sm font-medium text-white hover:bg-black">Update</button>
            </div>
        </form>
    </div>

    <script>
        window.populatePlanEdit = function(id, plan) {
            const form = document.getElementById('editPlanForm');
            if (!form) return;
            form.action = `{{ url('admin/plans') }}/${id}`;
            form.querySelector('[name="name"]').value = plan.name;
            form.querySelector('[name="price"]').value = plan.price;
            form.querySelector('[name="duration"]').value = plan.duration;
            form.querySelector('[name="max_posts_per_month"]').value = plan.max_posts_per_month;
            form.querySelector('[name="max_social_accounts"]').value = plan.max_social_accounts;
            form.querySelector('[name="ai_credits"]').value = plan.ai_credits;
            form.querySelector('[name="features"]').value = plan.features || '';
            form.querySelector('[name="status"]').value = plan.status;
        }
    </script>
</div>


