@extends('layouts.admin')

@section('title', 'Subscription Plans')

@section('content')
<div class="container">
    <div class="p-4 mx-auto max-w-(--breakpoint-2xl) md:p-6">
        <div class="grid grid-cols-12 gap-4 md:gap-6">
            <div class="col-span-12 xl:col-span-12">
                <div class="overflow-hidden rounded-2xl border border-gray-200 bg-white px-4 pb-3 pt-4 dark:border-gray-800 dark:bg-white/[0.03] sm:px-6">
                    <div class="flex flex-col gap-2 mb-4 sm:flex-row sm:items-center sm:justify-between">
                        <div>
                            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Subscription Plans</h3>
                        </div>

                        <div class="flex items-center gap-3">
                            <button class="inline-flex items-center gap-2 rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-theme-sm font-medium text-gray-700 shadow-theme-xs hover:bg-gray-50 hover:text-gray-800 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:hover:bg-white/[0.03] dark:hover:text-gray-200" onclick="openPlanModal('create')">
                                Create Plan
                            </button>
                        </div>
                    </div>

                    <div class="w-full overflow-x-visible">
                        <table id="plansTable" class="display w-full break-words">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Price</th>
                                    <th>Duration</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th data-orderable="false">Actions</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @include('admin.plans.partials.create-modal')
    @include('admin.plans.partials.view-modal')
    @include('admin.plans.partials.edit-modal')

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof DataTable !== 'undefined') {
                new DataTable('#plansTable', {
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: '{{ route('plans.data') }}',
                        type: 'GET'
                    },
                    columns: [
                        { data: 'name', name: 'name' },
                        { data: 'price', name: 'price' },
                        { data: 'duration', name: 'duration' },
                        { data: 'status', name: 'status' },
                        { data: 'created', name: 'created_at' },
                        { data: 'actions', name: 'actions', orderable: false, searchable: false }
                    ],
                    responsive: true,
                    columnDefs: [
                        { orderable: false, targets: -1 }
                    ],
                    layout: {
                        topEnd: { search: { placeholder: 'Search plans...' } },
                        bottomStart: null,
                        bottomEnd: { paging: { first: false, last: false, previous: false, next: false } }
                    },
                    language: {
                        search: "",
                        searchPlaceholder: "Search plans...",
                        lengthMenu: "Show _MENU_ entries",
                        info: "Showing _START_ to _END_ of _TOTAL_ entries",
                        paginate: { first: "First", last: "Last", next: "Next", previous: "Previous" }
                    }
                });
            }
        });
    </script>
</div>
@endsection


