<!-- View Category Modal -->
<div id="viewCategoryModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closeViewCategoryModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-3xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Category Details</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700 dark:hover:text-gray-300" onclick="closeViewCategoryModal()">
                <i class="fa-solid fa-times"></i>
            </button>
        </div>
        <div class="overflow-auto max-h-[70vh]">
            <div id="categoryDataContainer" class="space-y-4">
                <div class="text-center py-8">
                    <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900 dark:border-white"></div>
                    <p class="mt-2 text-gray-600 dark:text-gray-400">Loading category data...</p>
                </div>
            </div>
        </div>
        <div class="mt-6 flex items-center justify-end gap-3">
            <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50 dark:border-gray-700 dark:bg-gray-800 dark:text-gray-300" onclick="closeViewCategoryModal()">Close</button>
        </div>
    </div>
</div>

<script>
    window.openViewCategoryModal = function(categoryId) {
        const modal = document.getElementById('viewCategoryModal');
        const dataContainer = document.getElementById('categoryDataContainer');
        
        // Show modal with loading state
        dataContainer.innerHTML = `
            <div class="text-center py-8">
                <div class="inline-block animate-spin rounded-full h-8 w-8 border-b-2 border-gray-900 dark:border-white"></div>
                <p class="mt-2 text-gray-600 dark:text-gray-400">Loading category data...</p>
            </div>
        `;
        modal.classList.remove('hidden');
        
        // Fetch category data
        fetch(`/admin/categories/${categoryId}`)
            .then(response => response.json())
            .then(data => {
                // Format and display as HTML
                const createdDate = data.created_at ? new Date(data.created_at).toLocaleString() : 'N/A';
                const updatedDate = data.updated_at ? new Date(data.updated_at).toLocaleString() : 'N/A';
                
                dataContainer.innerHTML = `
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">ID</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${data.id || 'N/A'}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Category Name</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${escapeHtml(data.category_name) || 'N/A'}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Is Default</label>
                            <p class="mt-1">
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium ${data.is_default == 1 ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200'}">
                                    ${data.is_default == 1 ? 'Yes' : 'No'}
                                </span>
                            </p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">User ID</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${data.user_id || 'N/A'}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Created At</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${createdDate}</p>
                        </div>
                        <div class="bg-gray-50 dark:bg-gray-800 p-4 rounded-lg border border-gray-200 dark:border-gray-700">
                            <label class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wide">Updated At</label>
                            <p class="mt-1 text-sm font-medium text-gray-900 dark:text-white">${updatedDate}</p>
                        </div>
                    </div>
                `;
            })
            .catch(error => {
                dataContainer.innerHTML = `
                    <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded-lg p-4">
                        <p class="text-sm text-red-800 dark:text-red-200">Error loading category data: ${error.message}</p>
                    </div>
                `;
            });
    }
    
    window.closeViewCategoryModal = function() {
        const modal = document.getElementById('viewCategoryModal');
        modal.classList.add('hidden');
    }
    
    function escapeHtml(text) {
        if (!text) return '';
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#039;'
        };
        return text.toString().replace(/[&<>"']/g, m => map[m]);
    }
    
</script>

