<!-- Create Category Modal -->
<div id="createCategoryModal" class="fixed inset-0 z-50 hidden flex items-center justify-center">
    <div class="absolute inset-0 bg-black/50" onclick="closeCategoryModal()"></div>
    <div class="relative z-10 mx-4 w-full max-w-2xl rounded-2xl bg-white p-6 shadow-xl dark:bg-white/[0.03]">
        <div class="mb-4 flex items-center justify-between">
            <h3 class="text-lg font-semibold text-gray-800 dark:text-white/90">Create Category</h3>
            <button type="button" class="text-gray-500 hover:text-gray-700" onclick="closeCategoryModal()">✕</button>
        </div>
        <form id="createCategoryForm" action="{{ route('categories.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 gap-4 sm:grid-cols-2">
                <div class="sm:col-span-2">
                    <label class="mb-1 block text-sm font-medium text-gray-700">Category Name</label>
                    <input type="text" name="category_name" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" value="{{ old('category_name') }}" required />
                    @error('category_name')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">Is Default</label>
                    <div class="flex items-center">
                        <input type="checkbox" name="is_default" value="1" class="rounded border-gray-300 text-gray-600 focus:ring-gray-300" @checked(old('is_default', 1)) />
                        <span class="ml-2 text-sm text-gray-700">Set as default category</span>
                    </div>
                    @error('is_default')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="mb-1 block text-sm font-medium text-gray-700">User ID</label>
                    <input type="number" name="user_id" class="w-full rounded-lg border border-gray-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-gray-300" value="{{ old('user_id') }}" placeholder="Leave empty for null" />
                    @error('user_id')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
            <div class="mt-6 flex items-center justify-end gap-3">
                <button type="button" class="inline-flex items-center rounded-lg border border-gray-300 bg-white px-4 py-2.5 text-sm font-medium text-gray-700 hover:bg-gray-50" onclick="closeCategoryModal()">Cancel</button>
                <button type="submit" class="inline-flex items-center rounded-lg bg-gray-900 px-4 py-2.5 text-sm font-medium text-white hover:bg-black">Create</button>
            </div>
        </form>
    </div>
</div>

<script>
    // Open/Close Modal helpers
    window.openCategoryModal = function(mode) {
        if (mode !== 'create') return;
        const modal = document.getElementById('createCategoryModal');
        const form = document.getElementById('createCategoryForm');
        if (form) form.reset();
        if (modal) modal.classList.remove('hidden');
        // restore defaults after reset
        const isDefault = form?.querySelector('input[name="is_default"]');
        if (isDefault) isDefault.checked = true;
    }
    window.closeCategoryModal = function() {
        const modal = document.getElementById('createCategoryModal');
        if (modal) modal.classList.add('hidden');
    }
</script>

