<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\AppUser;
use App\Models\Category;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create Admin Users (for admin panel)
        User::create([
            'name' => 'Super Admin',
            'email' => 'admin@example.com',
            'password' => 'admin123', // Will be automatically hashed by the model
            'role' => 'admin',
            'timezone' => 'UTC',
            'status' => 'active',
        ]);

        User::create([
            'name' => 'Test Subscriber',
            'email' => 'subscriber@example.com',
            'password' => 'subscriber123', // Will be automatically hashed by the model
            'role' => 'subscriber',
            'timezone' => 'UTC',
            'status' => 'active',
        ]);

        // Create App Users (for frontend/API)
        AppUser::create([
            'name' => 'John Doe',
            'email' => 'john@yopmail.com',
            'password' => 'user123', // Will be automatically hashed by the model
            'timezone' => 'UTC',
            'status' => 'active',
            'email_verified_at' => now(),
        ]);

        AppUser::create([
            'name' => 'Smith',
            'email' => 'smith@yopmail.com',
            'password' => 'jane123', // Will be automatically hashed by the model
            'timezone' => 'UTC',
            'status' => 'active',
        ]);

        // Create Default Categories (for posts)
        Category::create([
            'category_name' => 'General',
            'is_default' => 1,
            'user_id' => null,
        ]);

        Category::create([
            'category_name' => 'Marketing',
            'is_default' => 1,
            'user_id' => null,
        ]);

        Category::create([
            'category_name' => 'News',
            'is_default' => 1,
            'user_id' => null,
        ]);

        Category::create([
            'category_name' => 'Technology',
            'is_default' => 1,
            'user_id' => null,
        ]);

        Category::create([
            'category_name' => 'Entertainment',
            'is_default' => 1,
            'user_id' => null,
        ]);

        Category::create([
            'category_name' => 'Business',
            'is_default' => 1,
            'user_id' => null,
        ]);
    }
}
