<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('subscription_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name', 100);
            $table->decimal('price', 10, 2)->default(0.00);
            $table->enum('duration', ['monthly', 'yearly'])->default('monthly');
            $table->integer('max_posts_per_month')->default(0);
            $table->integer('max_social_accounts')->default(0);
            $table->integer('ai_credits')->default(0);
            $table->longText('features')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('subscription_plans');
    }
};


