<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, modify the status enum to include 'scheduled'
        DB::statement("ALTER TABLE posts MODIFY COLUMN status ENUM('draft', 'scheduled', 'posted') DEFAULT 'draft'");
        
        // Add scheduled_at column
        Schema::table('posts', function (Blueprint $table) {
            $table->timestamp('scheduled_at')->nullable()->after('published_at');
            $table->index('scheduled_at');
            $table->index(['status', 'scheduled_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('posts', function (Blueprint $table) {
            $table->dropIndex(['status', 'scheduled_at']);
            $table->dropIndex(['scheduled_at']);
            $table->dropColumn('scheduled_at');
        });
        
        // Revert status enum back to original
        DB::statement("ALTER TABLE posts MODIFY COLUMN status ENUM('draft', 'posted') DEFAULT 'draft'");
    }
};

