<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_users', function (Blueprint $table) {
            $table->dropColumn([
                'company_category',
                'business_type',
                'business_registration_number',
                'business_established_date',
            ]);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_users', function (Blueprint $table) {
            $table->string('company_category')->nullable()->after('company_name');
            $table->string('business_type')->nullable()->after('company_description');
            $table->string('business_registration_number')->nullable()->after('preferred_social_platforms');
            $table->date('business_established_date')->nullable()->after('business_registration_number');
        });
    }
};

