<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_users', function (Blueprint $table) {
            // Company/Shop Information
            $table->string('company_name')->nullable()->after('name');
            $table->string('company_category')->nullable()->after('company_name');
            $table->text('company_description')->nullable()->after('company_category');
            $table->string('business_type')->nullable()->after('company_description'); // retail, service, ecommerce, restaurant, etc.
            
            // Contact Information
            $table->string('phone')->nullable()->unique()->after('email');
            $table->string('website')->nullable()->after('phone');
            $table->text('address')->nullable()->after('website');
            $table->string('city')->nullable()->after('address');
            $table->string('state')->nullable()->after('city');
            $table->string('country')->nullable()->after('state');
            $table->string('postal_code')->nullable()->after('country');
            
            // Social Media & Marketing
            $table->json('social_media_handles')->nullable()->after('postal_code'); // Store Facebook, Instagram, etc. handles
            $table->json('preferred_social_platforms')->nullable()->after('social_media_handles'); // Which platforms they want to post to
            
            // Business Details
            $table->string('business_registration_number')->nullable()->after('preferred_social_platforms');
            $table->date('business_established_date')->nullable()->after('business_registration_number');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_users', function (Blueprint $table) {
            $table->dropColumn([
                'company_name',
                'company_category',
                'company_description',
                'business_type',
                'phone',
                'website',
                'address',
                'city',
                'state',
                'country',
                'postal_code',
                'social_media_handles',
                'preferred_social_platforms',
                'business_registration_number',
                'business_established_date',
            ]);
        });
    }
};

